import React, { useEffect, useState } from "react";
import {
  Tabs,
  Button,
  Cascader,
  Space,
  DatePicker,
  DatePickerProps,
} from "antd";
import styles from "./index.module.scss";
import Layout from "~/components/layout";
import requirements from "./components/requirements"; //项目需求
import bids from "./components/bids"; //招投标项目
import cases from "./components/cases"; //业务案例
import news from "./components/news"; //行业新闻

interface Option {
  value: string | number;
  label: string;
  children?: Option[];
}

const options: Option[] = [
  {
    value: "zhejiang",
    label: "Zhejiang",
    children: [
      {
        value: "hangzhou",
        label: "Hangzhou",
        children: [
          {
            value: "xihu",
            label: "West Lake",
          },
        ],
      },
    ],
  },
  {
    value: "jiangsu",
    label: "Jiangsu",
    children: [
      {
        value: "nanjing",
        label: "Nanjing",
        children: [
          {
            value: "zhonghuamen",
            label: "Zhong Hua Men",
          },
        ],
      },
    ],
  },
];

const onChange = (value: string[]) => {
  console.log(value);
};

const onDateChange: DatePickerProps["onChange"] = (date, dateString) => {
  console.log(date, dateString);
};

const operations = (
  <Space size={8}>
    <Cascader
      options={options}
      onChange={onChange}
      placeholder="Please select"
      borderRadiusSM={6}
    />
    <DatePicker onChange={onDateChange} />
  </Space>
);

const items = ["项目需求", "招投标项目", "业务案例", "行业新闻"].map(
  (value) => {
    let children: JSX.Element | string = <></>;

    switch (value) {
      case "项目需求":
        children = requirements();
        break;

      case "招投标项目":
        children = bids();
        break;

      case "业务案例":
        children = cases();
        break;

      case "行业新闻":
        children = news();
        break;
    }
    return {
      label: `${value}`,
      key: value,
      children: children,
    };
  }
);

export default function Mall() {
  return (
    <Layout>
      <div style={{ paddingTop: 180, backgroundColor: "#fff", minHeight: 820 }}>
        <div className="page">
          <div className={styles.banner}></div>
          <Tabs
            className={styles.tabs}
            tabBarExtraContent={operations}
            items={items}
            tabBarGutter={41}
          />
        </div>
      </div>
    </Layout>
  );
}
