import { Button, Image, Space, Input } from "antd";
import Layout from "~/components/layout";
import styles from "./index.module.scss";
import errImg from "./assets/errImg";

export default function forum() {
  return (
    <Layout>
      <div className={styles.forum}>
        <div className={styles.header}>
          <div className={styles.title}>最新讨论</div>
          <Button className={styles.btn} type="primary">
            发布动态
          </Button>
        </div>
        <Space direction="vertical" size={8}>
          <div className={styles.item}>
            <Space size={10} align="start">
              <img className={styles.headImg}></img>
              <div className={styles.info}>
                <div className={styles.name}>给**的</div>
                <div className={styles.desc}>
                  今天飞的航拍效果，喜欢的给我点个赞
                </div>
                <div className={styles.imgs}>
                  <Image.PreviewGroup
                    preview={{
                      onChange: (current, prev) =>
                        console.log(
                          `current index: ${current}, prev index: ${prev}`
                        ),
                    }}
                  >
                    <Space size={6} wrap>
                      <Image
                        className="img"
                        width={132}
                        height={132}
                        src="errImg"
                        fallback={errImg}
                      />
                      <Image
                        className="img"
                        width={132}
                        height={132}
                        src="errImg"
                        fallback={errImg}
                      />
                      <Image
                        className="img"
                        width={132}
                        height={132}
                        src="errImg"
                        fallback={errImg}
                      />
                      <Image
                        className="img"
                        width={132}
                        height={132}
                        src="errImg"
                        fallback={errImg}
                      />
                      <Image
                        className="img"
                        width={132}
                        height={132}
                        src="errImg"
                        fallback={errImg}
                      />
                      <Image
                        className="img"
                        width={132}
                        height={132}
                        src="errImg"
                        fallback={errImg}
                      />
                      <Image
                        className="img"
                        width={132}
                        height={132}
                        src="errImg"
                        fallback={errImg}
                      />
                    </Space>
                  </Image.PreviewGroup>
                </div>
                <div className={styles.ctrls}>
                  <div className={styles.ctrlsItem}>
                    <div
                      className={`${styles.ctrlsItemIcon} ${styles.iconComment}`}
                    ></div>
                    15评论
                  </div>
                  <div className={styles.ctrlsItem}>
                    <div
                      className={`${styles.ctrlsItemIcon} ${styles.iconPraise} ${styles.active}`}
                    ></div>
                    11赞
                  </div>
                </div>
              </div>
            </Space>
            <div className={styles.commentWrap}>
              <div className={styles.draftWrap}>
                <div className={styles.commentHeadImg}>自已</div>
                <Input
                  className={styles.commentInput}
                  placeholder="说点什么吧，万一火了呢~"
                ></Input>
              </div>
              <div className={styles.btnCommentWrap}>
                <Button type="primary" className="btnComment">
                  评论
                </Button>
              </div>
              <div className={styles.comments}>
                <div className={styles.commentItem}>
                  <div className={styles.commentHeadImg}></div>
                  <div className={styles.info}>
                    <div className={styles.nameWrap}>
                      <div className={styles.commentName}>
                        无人机爱好者111：
                        <div className={styles.date}>05-16</div>
                      </div>
                      <div className={styles.commentContent}>
                        无人机记录生活
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </Space>
      </div>
    </Layout>
  );
}
