import request, { Response } from '~/api/request';

export interface ListNewTenderInfoParams {
  cityCode?: number;
  date?: string;
  districtCode?: number;
  pageNo: number;
  pageSize: number;
  provinceCode?: number;
}

export interface ListNewTenderInfoResp {
  pageNo: number;
  pageSize: number;
  list: Item[];
  totalCount: number;
  totalPage: number;
}

export interface Item {
  id: number;
  tenderNewsId: number;
  tenderInfoNo: string;
  tenderContent: string;
  tenderPrice: number;
  createTime: string;
  apply: 0 | 1;
  tenderTitle: string;
}

export interface ApplyParams {
  tenderInfoId?: number; // 招标详情id
  tenderNewsId?: number; // 招标id
}

export default {
  /**
   * 招投标列表
   * @param params
   * @returns
   */
  listNewTenderInfo(
    params: ListNewTenderInfoParams,
    options = {},
  ): Promise<Response<ListNewTenderInfoResp>> {
    return request('/release/tender/listNewTenderInfo', 'post', params, options);
  },
  // 合作申请提交
  apply(params: ApplyParams) {
    return request('/release/tender/apply', 'post', params);
  },
};
