import request, { Response } from '~/api/request';

export interface ListPageWechatOrderParams {
  buyerAccount?: string;
  endTime?: string;
  orderNo?: string;
  pageNo: number;
  pageSize: number;
  startTime?: string;
  tranStatus?: string;
  wareNo?: string;
  wareTitle?: string;
}

export interface ListPageWechatOrderResp {
  pageNo: number;
  pageSize: number;
  list: LeasingList[];
  totalCount: number;
  totalPage: number;
}

export interface LeasingList {
  id: number;
  orderNo: string;
  createTime?: any;
  wareInfoId?: any;
  wareNo?: any;
  wareTitle: string;
  wareImg: string;
  skuInfoId?: any;
  skuTitle?: any;
  repoAccountId?: any;
  uid?: any;
  buyerName?: any;
  buyerPhone?: any;
  unitPrice?: any;
  wareNum: number;
  shouldPay: number;
  actualPay: number;
  orderType?: any;
  deposit?: any;
  rentPrice?: any;
  startDate?: any;
  endDate?: any;
  payDay?: any;
  tranStatus: string;
  exWare?: any;
  remark?: any;
  pfRemark?: any;
  shutReason?: any;
  payNo?: any;
  payTime?: any;
  sendWareTime?: any;
  receipt: Receipt;
  orderRefund?: any;
  express?: any;
  refundExpress?: any;
  vcus?: any;
  returnTime?: any;
  couponId?: any;
  specsId?: any;
  balance?: any;
  doing?: any;
  waiting?: any;
  leaseOrderStatus?: any;
  nickName?: any;
  wareDescription?: any;
}

interface Receipt {
  id: number;
  receiptMethod: number;
  takeName: string;
  takePhone: string;
  region: string;
  detailAddress: string;
  repoName?: any;
  repoAddress?: any;
  bookPhone?: any;
  sendExCode?: any;
  sendExNo?: any;
  sendAddress?: any;
  renMethod?: any;
  renPhone?: any;
  renName?: any;
  renExCode?: any;
  renExNo?: any;
  renAddress?: any;
  renRepoName?: any;
  renRepoAddr?: any;
  renRepoPhone?: any;
}

export interface ListTranStatusResp {
  status: string;
  doing: string;
  waiting: string;
  leaseOrderStatus: string;
}

export default {
  // 订单分页列表
  listPageWechatOrder(
    params: ListPageWechatOrderParams,
    options?: any,
  ): Promise<Response<ListPageWechatOrderResp>> {
    return request('/oms/RentalOrders/listPageWechatOrder', 'post', params, options);
  },

  // 订单状态-字典
  listTranStatus(): Promise<Response<ListTranStatusResp[]>> {
    return request('/oms/RentalOrders/listTranStatus', 'get');
  },
};
