import { FC } from 'react';

import { Modal, ModalProps, Image } from 'antd';

import { Box } from './styled';

interface SelfProps {
  wxCodeImg: string;
}

const WxCodeModal: FC<ModalProps & SelfProps> = ({ open, onCancel, wxCodeImg }) => {
  return (
    <Modal open={open} onCancel={onCancel} width={400} footer={null}>
      <Box>
        <div className='title'>立即申请合作</div>
        <div className='img'>
          <Image src={wxCodeImg} width={160} height={160} alt={'图片'} />
        </div>
        <div className='meta'>打开微信扫一扫</div>
      </Box>
    </Modal>
  );
};
export default WxCodeModal;
