import { Image } from 'antd';

import errImg from '~/assets/errImg';

import styles from './index.module.scss';

const qrcodeList = [
  {
    img: '/assets/xiaochengxu.png',
    title: '轻松玩转',
    meta: '云享飞小程序',
  },
  {
    img: '/assets/fuwuhao.png',
    title: '云享飞服务号',
    meta: '',
  },
  {
    img: '/assets/mmc.png',
    title: '科比特官网',
    url: 'http://www.mmcuav.cn/',
    meta: '',
  },
  {
    img: '/assets/shequn.png',
    title: '官方社群',
    meta: '',
  },
];

export default function Footer() {
  return (
    <div className={styles.footer}>
      <div className={styles.footerBox}>
        {/* <div className={styles.logo}></div> */}
        <div className={styles.qrcodeList}>
          {qrcodeList.map((item, i) => {
            return (
              <div className={styles.qrcodeItem} key={i}>
                <Image
                  style={{
                    cursor: item.title === '科比特官网' ? 'pointer' : '',
                  }}
                  onClick={() => {
                    if (item.title === '科比特官网') window.open(item.url, '_blank');
                  }}
                  alt=''
                  className={styles.qrcodeImg}
                  src={item.img}
                  fallback={errImg}
                  preview={item.title !== '科比特官网'}
                ></Image>
                <div className={styles.qrcodeContent}>
                  <div className={styles.qrcodeTitle}>{item.title}</div>
                  {item.meta ? <div className={styles.qrcodeTitle}>{item.meta}</div> : ''}
                </div>
              </div>
            );
          })}
        </div>
      </div>
      <div className={styles.filingNumber}>浙ICP备2023014395号</div>
    </div>
  );
}
