import { Button } from "antd";
import styles from "./index.module.scss";

const list = [
  {
    isApply: false,
  },
  {
    isApply: true,
  },
];

export default function requirements() {
  return (
    <div className={styles.bids}>
      {list.map((item, i) => {
        return (
          <div className={styles.item} key={i}>
            <div className={styles.info}>
              <div className={styles.title}>项目需求：电力巡检需要5名飞手</div>
            </div>
            {item.isApply ? (
              <Button
                type="primary"
                disabled
                className={`${styles.btn} ${styles.disabled}`}
              >
                <div className={styles.text1}>155W</div>
                <div className={styles.text2}>已申请</div>
              </Button>
            ) : (
              <Button type="primary" className={styles.btn}>
                <div className={styles.text1}>155W</div>
                <div className={styles.text2}>申请合作</div>
              </Button>
            )}
          </div>
        );
      })}
    </div>
  );
}
