import CategoryItem from "./compoents/categoryItem";
import { FilterOptionResp, leasingApi, mallApi } from "./api";
import ResultItem from "./compoents/resultItem";
import RegionItem from "./compoents/regionItem";
import styles from "./index.module.scss";
import { useEffect, useState } from "react";
import BrandItem from "./compoents/brandItem";
import ModelItem from "./compoents/modelItem";
import PartItem from "./compoents/partItem";
import QualityItem from "./compoents/qualityItem";

export type FilterResult = {
  category?: FilterOptionResp | undefined;
};

type itemType = "类目" | "地域" | "品牌" | "部件" | "型号" | "成色";

type Props = {
  types: [itemType, itemType, itemType, itemType, itemType, itemType];    //需要包含的筛选条件项
  showResultItem: Boolean; //显示结果栏
  categoryData?: Array<FilterOptionResp>;
  regionData?: Array<FilterOptionResp>;
  brandData?: Array<FilterOptionResp>;
  modelData?: Array<FilterOptionResp>;
  partData?: Array<FilterOptionResp>;
  qualityData?: Array<FilterOptionResp>;
  onChange: (filterResult: FilterResult) => void; //筛选条件更改事件
};
export default function Filter(props: Props) {
  const [result, setResult] = useState<FilterResult>({});
  const onChange = (item: FilterOptionResp, type: string) => {
    let data: { [key: string]: FilterOptionResp } = {};
    data[type] = item;
    setResult({ ...result, ...data });
  };

  useEffect(() => {
    props.onChange(result);
  }, [result, props]);
  const onDel = (key: string) => {
    //@ts-ignore
    delete result[key];
    setResult({
      ...result,
    });
  };
  return (
    <>
      {props.types.includes("地域") && (
        <div
          className={styles.filterWrap}
          style={{
            marginBottom: 18,
          }}
        >
          <RegionItem></RegionItem>
        </div>
      )}
      <div className={styles.filterWrap}>
        {props.types.includes("品牌") && (
          <BrandItem
            data={props.brandData || []}
            onChange={(item: FilterOptionResp) => onChange(item, "brand")}
          ></BrandItem>
        )}
        {props.types.includes("类目") && (
          <CategoryItem
            data={props.categoryData || []}
            onChange={(item: FilterOptionResp) => onChange(item, "category")}
          ></CategoryItem>
        )}
        {props.types.includes("部件") && (
          <PartItem
            data={props.partData || []}
            onChange={(item: FilterOptionResp) => onChange(item, "part")}
          ></PartItem>
        )}
        {props.types.includes("型号") && (
          <ModelItem
            data={props.modelData || []}
            onChange={(item: FilterOptionResp) => onChange(item, "model")}
          ></ModelItem>
        )}
        {props.types.includes("成色") && (
          <QualityItem
            data={props.qualityData || []}
            onChange={(item: FilterOptionResp) => onChange(item, "quality")}
          ></QualityItem>
        )}

        {props.showResultItem && (
          <ResultItem data={result} onDel={onDel}></ResultItem>
        )}
      </div>
    </>
  );
}

Filter.mallApi = mallApi;
Filter.leasingApi = leasingApi;
