import React, { useEffect, useState } from "react";
import { Space, Select, Button } from "antd";
import Image from "next/image";
import { useRouter } from "next/router";
import { Box } from "./styled";
import ContentBox from "~/components/contentBox";
import RotationChart from "./components/rotationChart";
import Map from "./components/map";

import tubiao from "./assets/tubiao.png";
import fuwu from "./assets/fuwu.png";
import xiaoshou from "./assets/xiaoshou.png";
import baoxian from "./assets/baoxian.png";
import peixun from "./assets/peixun.png";
import gongju from "./assets/gongju.png";
import xwbg from "./assets/xwbg.png";
const icon = [tubiao, fuwu, xiaoshou, baoxian, peixun, gongju];
import {
  FilterOptionResp,
  RegionResp,
  AllType,
  AppType,
  IndustryType,
  SkillsType,
  NewsPageType,
  NewsTenderType,
  equipmentLeasingApi,
  jobServicesApi,
  mallApi,
  flightSkillsApi,
  listNewsApi,
} from "./api";
import { BaseOptionType, DefaultOptionType } from "antd/es/select";

interface ColumnsType {
  title: string;
  router: string;
}

export default function WaterfallFlowBody() {
  const router = useRouter();
  const onMoreChange = (value: string) => {
    console.log("更多", value);
  };
  const [list, setList] = useState([
    "中国人寿",
    "中国平安",
    "中国人保",
    "太平洋保险",
    "新华保险",
    "中国太平",
    "泰康保险",
    "华夏保险",
    "阳光保险",
    "富德生命人寿",
    "中邮人寿",
    "前海人寿",
    "百年人寿",
    "国华人寿",
    "工银安盛人寿",
    "恒大人寿",
    "君康人寿",
    "友邦保险",
    "建信人寿",
    "大家人寿",
    "农银人寿",
    "中信保城人寿",
    "合众人寿",
  ]);
  const [list2, setList2] = useState([
    "天目将PAAS平台",
    "天目将公安平台",
    "天目将应急平台",
    "天目将城管平台",
    "天目将电力平台",
    "天目将石油平台",
    "SESP-U1无人机仿真软件",
    "云享飞服务号",
    "无人机商城",
    "云飞手",
    "云仓",
    "云享飞",
    "科比特智教",
  ]);
  //  const [brandData,setBrandData] = useState<FilterOptionResp[]>([])

  const [moreEqList, setMoreEqList] = useState<any>();

  const columns = [
    {
      title: "无人机出租",
      router: "/equipmentLeasing",
    },
    {
      title: "无人机销售",
      router: "/mall",
    },
    {
      title: "无人机保险",
      router: "",
    },
    {
      title: "无人机培训",
      router: "flyingHandService",
    },
    {
      title: "无人机服务",
      router: "/jobServices",
    },
    {
      title: "无人机工具软件",
      router: "",
    },
  ];

  const [leftDomList, setLeftDomList] = useState(
    Array<{ element: JSX.Element , type?: string,}>
  );
  const [rightTopDomList, setRightTopDomList] = useState<JSX.Element>();
  const [rightBottomDomList, setRightBottomDomList] = useState<JSX.Element>();

  const { deviceCategory, deviceBrand, deviceModel } = equipmentLeasingApi;
  const eqApiTypeList = ["categoryId", "brandId", "modelId"];

  const { listAllCategory, listAllParts, listAllQuality } = mallApi;
  const mallApiTypeList = [
    "brandId",
    "productCategoryId",
    "partsId",
    "modelId",
    "qualityId",
  ];
  const { IndustryFlightSkills } = flightSkillsApi;
  const flightApiTypeList = ["licenseId", "flightSkillsId"];
  
  const { listAllIndustry, listAllAppType } = jobServicesApi;
  const jobApiTypeList = ["industryId", "appTypeId"];


  useEffect(() => {
    (async () => {
      // listNewsApi.listNewsPage({ pageNo: 1, pageSize: 5 }).then((res) => {
      //   setRightTopDomList(rightDom(res.result?.list!));
      // });
      // listNewsApi.listNewTenderInfo({ pageNo: 1, pageSize: 6 }).then((res) => {
      //   setRightBottomDomList(rightDom2(res.result?.list!));
      // });

      let res1 = await Promise.all([
        deviceCategory(),
        deviceBrand(),
        deviceModel(),
      ]);
      let res2 = await Promise.all([
        listAllCategory(),
        listAllParts(),
        listAllQuality(),
      ]);
      let res3 = await Promise.all([IndustryFlightSkills()]);
      let res4 = await Promise.all([listAllIndustry(), listAllAppType()]);
      //  let res4 = await Promise.all([deviceCategory(),deviceBrand(),deviceModel()])
      //  let res6 = await Promise.all([deviceCategory(),deviceBrand(),deviceModel()])

      const resValuelist1 = res1
        .map((item, index) => {
          return item.result?.map((it) => {
            it.type = eqApiTypeList[index];
            return it;
          });
        })
        .flat();
      const resValuelist2 = res2
        .map((item, index) => {
          return item.result?.map((it) => {
            it.type = jobApiTypeList[index];
            return it;
          });
        })
        .flat();
      const resValuelist3 = res3
        .map((item, index) => {
          return item.result?.map((it) => {
            it.type = mallApiTypeList[index];
            return it;
          });
        })
        .flat();
      const resValuelist4 = res4
        .map((item, index) => {
          return item.result?.map((it) => {
            it.type = flightApiTypeList[index];
            return it;
          });
        })
        .flat();

      let res7 = await listNewsApi.listNewsPage({ pageNo: 1, pageSize: 5 });
      let res8 = await listNewsApi.listNewTenderInfo({
        pageNo: 1,
        pageSize: 6,
      });
      const listValue: any = [
        resValuelist1,
        resValuelist2,
        [],
        resValuelist3,
        resValuelist4.flat(),
        [],
      ];

      setMoreEqList(res1.map((item) => item.result).flat());
      setLeftDomList(
        columns.map((item, index) => {
          
          if (index < 3) {
            console.log("路由跳转",index);
            return { element: leftDom(item, index, listValue) , type:"left" };  
          }
          console.log("路由跳转",index);
          return { element: leftDom(item, index, listValue) , type:"right" };  
        })
      );

      setRightTopDomList(rightDom(res7.result?.list!));
      setRightBottomDomList(rightDom2(res8.result?.list!));
    })();
  }, []);

  const routerPath = (index: number, item?: AllType) => {
    console.log(index);
    
    if (item) {
      router.push({
        pathname: columns[index].router,
        query: { [item?.type!]: item?.id! },
      });
    } else {
      router.push({
        pathname: columns[index].router,
      });
    }
  };

  const leftDom = (
    item: ColumnsType,
    index: number,
    resultList: Array<Array<AllType>>
  ) => {
    return (
      <div key={item.title} className="item">
        <div className="item-title">
          <div className="item-left">
            {/* <div className="item-left-icon">
              <Image src={icon[index]} alt="#" />
            </div> */}
            <div className="item-left-label">{item.title}</div>
          </div>
          <div>
            <Select
              className="select-box"
              placeholder="筛选"
              onChange={onMoreChange}
              bordered={false}
              dropdownMatchSelectWidth={false}
              options={moreEqList}
              fieldNames={{ value: "id", label: "name" }}
            />
          </div>
        </div>
        <div className="item-body">
          <Space size={[15, 0]} wrap>
            {index === 2
              ? list.map((item, index) => (
                  <div
                    key={item}
                    className={`item-bubble ${
                      index === 0 || index === 1 || index === 2 ? "active" : ""
                    }`}
                  >
                    {item}
                  </div>
                ))
              : index === 5
              ? list2.map((item, index) => (
                  <div
                    key={item}
                    className={`item-bubble ${
                      index === 0 || index === 1 || index === 2 ? "active" : ""
                    }`}
                  >
                    {item}
                  </div>
                ))
              : resultList[index].map((item, indexer) => {
                  return (
                    <div
                      key={item?.name || item?.appName || item?.skillsName}
                      className={`item-bubble ${
                        indexer === 0 || indexer === 1 || indexer === 2
                          ? "active"
                          : ""
                      }`}
                      onClick={() => routerPath(index, item)}
                    >
                      {item?.name || item?.appName || item?.skillsName}
                    </div>
                  );
                })}
          </Space>
          <div className="item-bottom" onClick={() => routerPath(index)}>
            全部
          </div>
        </div>
      </div>
    );
  };

  const rightDom = (list: Array<NewsPageType>) => {
    return (
      <div key={1009} className="right-box-item right-item">
        <div className="title">
          行业新闻
          <div
            className="title-label"
            onClick={() => router.push("/projectInfo")}
          >
            &gt;
          </div>
        </div>
        <div className="body">
          {list?.map((item, index) => (
            <div key={item.id} className="body-item">
              <div
                className={`item-ranking ${index === 0 ? "one" : ""} ${
                  index === 1 ? "two" : ""
                } ${index === 2 ? "san" : ""}`}
              >
                {index + 1}
              </div>
              <div className="item-label" title={item.newsTitle}>
                {item.newsTitle}
              </div>
            </div>
          ))}
        </div>
      </div>
    );
  };

  const rightDom2 = (list: Array<NewsTenderType>) => {
    return (
      <div key={1008} className="right-box-item right-item-second">
        <Image src={xwbg} alt="#" width={384} height={249} />
        <div className="item-box">
          <div className="title">
            招标快讯
            <div
              className="title-label"
              onClick={() => router.push("/projectInfo")}
            >
              &gt;
            </div>
          </div>
          <div className="body">
            {list?.map((item) => (
              <div key={item.id} className="body-item">
                <div className="item-label" title={item.tenderContent}>
                  {item.tenderContent}
                  <div className="label-bottom">{item.tenderPrice}</div>
                </div>
                <div className="item-right">
                  <Image
                    src={require("./assets/button.png")}
                    alt="#"
                    width={103}
                    height={22}
                  />
                  <div className="left">{item.tenderPrice}W</div>
                  <div className="right">申请合作</div>
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>
    );
  };

  return (
    <Box>
      <ContentBox
        boxIndex={1} //分为左右两列，每列一个,从上而下
        leftcontentstyle={{
          width: "806px",
          margin: { top: 0, right: "10px", bottom: "10px", left: 0 },
        }}
        leftWaterfallDom={{
          columns: [
            { noFor: true, element: <RotationChart key={45645645} /> },
            ...leftDomList,
          ],
        }}
        rightRenderDom={{
          columns: [
            { element: <Map key={1001} /> },
            { element: rightTopDomList as JSX.Element },
            { element: rightBottomDomList as JSX.Element },
          ],
        }}
      />
    </Box>
  );
}
