// user.ts
import { createSlice } from '@reduxjs/toolkit';
import { HYDRATE } from 'next-redux-wrapper';

export type GlobalDataState = {
  loginModalVisible: boolean;
};

const initialState: GlobalDataState = {
  loginModalVisible: false,
};

const globalDataSlice = createSlice({
  name: 'globalData',
  initialState,
  reducers: {
    setGlobalData: (state, action) => {
      return action.payload;
    },
  },
  extraReducers: {
    // hydrated 用于获取服务端注入的state并选择更新
    [HYDRATE]: (state, action) => {
      return {
        ...action.payload.globalData,
      };
    },
  },
});

export const { setGlobalData } = globalDataSlice.actions;
export default globalDataSlice.reducer;
