import React from 'react';
import { PropertySafetyFilled, ShoppingCartOutlined } from '@ant-design/icons';
import styled from 'styled-components';
import { InterDataType } from '@/api/interface';
import { QueryGoodsInfoByCategorySub } from '@/api/interface/home';

const ProductItemWrap = styled.div`
  position: relative;
  box-sizing: border-box;
  width: calc((100% - (0.83rem * 5)) / 6);
  height: 15rem;
  border: 0.02rem solid #e3e3e3;
  margin: 0 0.83rem 0.83rem 0;
  padding: 0.67rem;
  cursor: pointer;
  &:nth-child(6n) {
    margin-right: 0;
  }
  &:active,
  &:hover {
    background: #fff9f6;
    border: 0.04rem solid #ff7a3e;
  }
  .product-image {
    position: relative;
    width: 100%;
    height: 8rem;
    box-sizing: border-box;
    .image {
      width: 100%;
      height: 100%;
      object-fit: contain;
    }
  }
  .product-title {
    width: 100%;
    font-size: 13px;
    font-weight: 500;
    color: #333333;
    display: -webkit-box;
    -webkit-box-orient: vertical;
    -webkit-line-clamp: 2;
    overflow: hidden;
    margin-bottom: 0.33rem;
  }
  .product-desc {
    position: relative;
    width: 100%;
    font-size: 12px;
    font-weight: 400;
    color: #999999;
    .label {
      width: 60%;
    }
    .text {
      width: 40%;
      text-align: right;
    }
  }
  .product-store {
    position: absolute;
    left: 0.67rem;
    bottom: 0.67rem;
    .title {
      width: 6rem;
      font-size: 12px;
      font-weight: 400;
      color: #666666;
      margin-left: 0.25rem;
    }
  }
  .product-cart {
    position: absolute;
    right: 0.67rem;
    bottom: 0.67rem;
    width: 2rem;
    height: 2rem;
    background: #ff8b2e;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    &:active,
    &:hover {
      filter: brightness(0.9);
    }
  }
`;

// 商品详情类型
type GoodsInfoListType = InterDataType<QueryGoodsInfoByCategorySub>[0];

const ProductItemView: React.FC<{
  detail: GoodsInfoListType;
}> = ({ detail }) => {
  return (
    <ProductItemWrap>
      <div className="product-image">
        <img
          className="image"
          src={`${detail?.resourcesList?.at(0)
            ?.url}?x-oss-process=image/quality,q_20`}
          alt={detail?.tradeName}
        />
      </div>
      <div className="product-title">{detail?.tradeName}</div>
      <div className="product-desc flex-between">
        <div className="label text-ellipsis">{detail?.description}</div>
        <div className="text text-ellipsis">成交{detail?.id}件</div>
      </div>
      <div className="product-store flex-start">
        <PropertySafetyFilled style={{ color: '#FF552D' }} />
        <div className="title text-ellipsis">{detail?.tradeName}</div>
      </div>
      <div className="product-cart">
        <ShoppingCartOutlined style={{ color: '#ffffff', fontSize: '16px' }} />
      </div>
    </ProductItemWrap>
  );
};

export default ProductItemView;
