import React from 'react';
import { Button } from 'antd';
import { FooterWrap } from '@/components/layout/footer/styled';

const FooterView = () => {
  // 关于列表
  const aboutList = [
    {
      img: '/assets/image/about/xiaochengxu.png',
      name: '云享飞小程序',
      alt: '云享飞小程序',
    },
    {
      img: '/assets/image/about/fuwuhao.png',
      name: '云享飞服务号',
      alt: '云享飞服务号',
    },
    {
      img: '/assets/image/about/shequn.png',
      name: '官方社群',
      alt: '官方社群',
    },
  ];
  return (
    <FooterWrap>
      <div className="footer-wrap">
        <div className="footer-start">
          <div className="start-item">
            <div className="item-title">了解我们</div>
            <div className="item-content">
              云享飞是由杭州云享飞科技有限公司独立运营的无人机服务平台，云享飞为客户提供一站式的无人机需求服务，包括商品购买、设备租赁、发布订单等。
            </div>
          </div>
          <div className="start-item">
            <div className="item-title">集团公司</div>
            <Button type={'link'} className="item-link">
              浙江科比特
            </Button>
            <Button type={'link'} className="item-link">
              深圳科比特
            </Button>
            <Button type={'link'} className="item-link">
              更多集团公司
            </Button>
          </div>
          <div className="start-item">
            <div className="item-title">合作伙伴</div>
            <Button type={'link'} className="item-link">
              浙江科比特
            </Button>
            <Button type={'link'} className="item-link">
              深圳科比特
            </Button>
            <Button type={'link'} className="item-link">
              更多合作伙伴
            </Button>
          </div>
          <div className="start-item">
            <div className="item-title">商家入驻</div>
            <Button type={'link'} className="item-link">
              合作咨询
            </Button>
            <Button type={'link'} className="item-link">
              加盟政策
            </Button>
          </div>
          <div className="start-item">
            <div className="item-title">关于我们</div>
            <div className="item-about">
              {aboutList?.map((i, j) => (
                <div className="about-item" key={j}>
                  <img src={i.img} alt={i.alt} className="item-logo" />
                  <div className="item-name">{i.name}</div>
                </div>
              ))}
            </div>
          </div>
        </div>
        <div className="footer-end">
          <Button type={'link'} className="end-item">
            常见问题
          </Button>
          <Button type={'link'} className="end-item">
            意见反馈
          </Button>
          <Button type={'link'} className="end-item">
            加盟入驻
          </Button>
          <Button
            type={'link'}
            className="end-item"
            onClick={() => {
              window.location.href = 'https://beian.miit.gov.cn';
            }}
          >
            浙ICP备2023014395号
          </Button>
        </div>
      </div>
    </FooterWrap>
  );
};

export default FooterView;
