import { InterDataType, InterFunction } from '@/api/interface';

// 小程序分类信息--含一二级分类
export type GetAppCategoryInfo = InterFunction<
  {},
  {
    id: number;
    name: string;
    description?: string;
    icon?: string;
    createTime?: string;
    updateTime?: null;
    subDTOList?: Array<{
      id: number;
      name: string;
      description?: string;
      categoryPrimaryId?: number;
      createTime?: string;
      updateTime?: string;
      subDTOList?: InterDataType<QueryGoodsInfoByCategorySub>;
    }>;
    sort?: number;
  }[]
>;
export type QueryGoodsInfoByCategorySub = InterFunction<
  number[],
  {
    categoryPrimaryId: number;
    categorySubId: number;
    createTime: string;
    description: string;
    goodsDetails: string;
    goodsLabel: string;
    goodsSpecList: Array<{
      chooseType: number;
      goodsSpecValuesList: Array<{
        channelPrice: number;
        goodsSpecId: number;
        id: number;
        partNo: string;
        salePrice: number;
        showPrice: number;
        specValueImage: string;
        specValueName: string;
        stock: number;
      }>;
      id: number;
      mallGoodsId: number;
      must: number;
      skuUnitId: number;
      specName: string;
    }>;
    id: number;
    labelShow: number;
    resourcesList: Array<{
      id: number;
      type: number;
      url: string;
    }>;
    shelfStatus: number;
    tradeName: string;
    userAccountId: number;
    recommend: number;
  }[]
>;
