import React from 'react';
import { Modal } from 'antd';
import styled from 'styled-components';

export const QrcodeModalWrap = styled.div`
  position: relative;
  width: 100%;
  min-height: 16.8rem;
  display: flex;
  align-items: center;
  justify-content: flex-start;
  flex-direction: column;
  box-sizing: border-box;
  padding-top: 1rem;
  .qrcode {
    width: 12.68rem;
    height: 15.68rem;
    background-image: url('https://file.iuav.com/file/sharefly-qrcode-wx.jpg');
    //background-size: 100% 100%;
    background-size: cover;
    background-position: center;
  }
  .title {
    color: #000;
    font-size: 13px;
    margin-top: 1rem;
    font-weight: bold;
  }
`;
const QrcodeModalView = ({
  open,
  onCancel,
}: {
  open: boolean;
  onCancel: () => void;
}) => {
  return (
    <Modal title="提示" open={open} footer={null} onCancel={onCancel}>
      <QrcodeModalWrap>
        <div className="qrcode"></div>
        <div className="title">功能正在完善中</div>
        <div className="title">请前往小程序以获得更好体验</div>
      </QrcodeModalWrap>
    </Modal>
  );
};
export default QrcodeModalView;
