import { InterFunction } from '@/api/interface';

// 获取二维码
export type GetAppletQRCode = InterFunction<
  // 入参
  {
    page: string;
    scene: string;
  },
  // 出参
  string
>;
// 查询登录信息
export type GetLoginInfo = InterFunction<
  {
    randomLoginCode: string;
  },
  {
    token: string;
    openId: string;
    userAccountId: number;
    accountNo: null;
    portType: number;
    uid: string;
    phoneNum: string;
    userName: string;
    nickName: string;
    companyInfoVO: null;
    roleInfo: null;
    appUserAccountId: null;
  }
>;
// 获取用户信息
export type GetAccountInfo = InterFunction<
  {},
  {
    accountStatus: number;
    accountType: number;
    companyAuthStatus: number;
    email: string;
    id: number;
    nickName: string;
    phoneNum: string;
    portType: number;
    source: number;
    uid: string;
    userImg: string;
    userName: string;
    userSex: number;
    realNameAuthStatus: number;
    auditStatus: number;
    totalPoints: number;
    xzAuthStatus: number;
    cooperationTagVOS: {
      createTime: string;
      id: number;
      tagDescription: string;
      tagImg: string;
      tagName: string;
      tagRequire: string;
    }[];
    coverPicture: string;
    districtChildId: number;
    region: string;
    briefIntroduction: string;
    companyInfoVO: {
      address: string;
      backImg: string;
      backUserAccountId: number;
      brandLogo: string;
      brandName: string;
      companyName: string;
      companyType: number;
      companyUserName: string;
      content: string;
      creditCode: string;
      distance: number;
      fullName: string;
      id: number;
      lat: number;
      leader: number;
      licenseImg: string;
      lon: number;
      phoneNum: number;
      remark: string;
      score: string;
      userAccountId: number;
    };
    createTime: string;
  }
>;
