import request, { Response } from '~/api/request';

export interface ListNewsPageParams {
  cityCode?: number;
  date?: string;
  districtCode?: number;
  pageNo: number;
  pageSize: number;
  provinceCode?: number;
}

export interface ListNewsPageResp {
  pageNo: number;
  pageSize: number;
  list: Item[];
  totalCount: number;
  totalPage: number;
}

export interface Item {
  id: number;
  newsTitle: string;
  newsAuthor: string;
  userAccountId: number;
  surfaceImg: string;
  newsContents: string;
  createTime: string;
  updateTime?: any;
}

export default {
  /**
   * 新闻列表
   * @param params
   * @returns
   */
  listNewsPage(params: ListNewsPageParams, options = {}): Promise<Response<ListNewsPageResp>> {
    return request('/release/industry-news/listNewsPage', 'post', params, options);
  },
};
