import request, { Response } from '~/api/request';

export interface GetWebDeviceDetailParams {
  actualPay: number;
  deposit: number;
  endDate: string;
  orderReceipt: {
    detailAddress: string;
    receiptMethod: number;
    region: string;
    takeName: string;
    takePhone: number;
  };
  rentPrice: number;
  returnDate: string;
  shouldPay: number;
  specsId: number;
  startDate: string;
  wareDescription: string;
  wareImg: string;
  wareInfoId: number;
  wareNo: string;
  wareNum: number;
  wareTitle: string;
  remark?: string;
}

export interface WareImgsType {
  id: number;
  imgUrl: string;
  imgType: number;
}

export interface UserAddress {
  id: number;
  takeName: string;
  takePhone: string;
  takeRegion: string;
  takeAddress: string;
  type: number;
}

export interface GetOrderForGoods {
  balance: number;
  nickName: string;
  orderNo: string;
}

export default {
  //web-地址管理-查询用户地址列表-条件查询
  listUserAddress: (params: {}): Promise<Response<UserAddress[]>> => {
    return request('/oms/user-address/selectList', 'POST', params);
  },
  //web-设备租赁-下单
  FeignAddLease: (params: GetWebDeviceDetailParams): Promise<Response<GetOrderForGoods>> => {
    return request('/oms/RentalOrders/feignAddLease', 'post', params);
  },
  //web-设备租赁-订单支付
  OrderPayment: (params: { orderNo: string }): Promise<Response<GetOrderForGoods>> => {
    return request(`/payment/repocash/orderPayment`, 'get', params);
  },
};
