import { Space, Tag } from 'antd';
import { FilterResult } from '../..';
import styles from '../../index.module.scss';
import { InfoList } from '../../api';
type Props = {
  data: FilterResult;
  onDel: (key: string | number) => void;
};
export default function ResultItem({ data, onDel }: Props) {
  return (
    <div className={styles.filterItem}>
      <div className={styles.filterItemTitle}>已选：</div>
      <div className={styles.filterItemMain}>
        <Space size={10}>
          {data.provinceId && (
            // Object.keys(data).map((key) => {
            //   //@ts-ignore
            //   let item = data[key]
            //   return (
            //     <Tag
            //       closable
            //       onClose={(e: React.MouseEvent<HTMLElement, MouseEvent>) => {
            //         onDel(key)
            //       }}
            //       key={key}
            //     >
            //       {item?.name}
            //     </Tag>
            //   )
            // })
            <Tag
              closable
              onClose={(e: React.MouseEvent<HTMLElement, MouseEvent>) => {
                onDel('provinceId');
              }}
              key={data.provinceId.id}
            >
              {data.provinceId.name}
            </Tag>
          )}
          {data.categoryId &&
            data.categoryId.map((item: InfoList, index) => {
              return (
                <Tag
                  closable
                  onClose={(e: React.MouseEvent<HTMLElement, MouseEvent>) => {
                    onDel(item.id);
                  }}
                  key={item.name}
                >
                  {item?.name}
                </Tag>
              );
            })}
        </Space>
      </div>
    </div>
  );
}
