import qs from 'querystring';
import React from 'react';
import { useRouter } from 'next/router';
import styled from 'styled-components';
import { InterListType } from '@/api/interface';
import { ListNewsType } from '@/api/interface/home';

// 详情类型
type DetailType = InterListType<ListNewsType>[0];

const NewsListItem: React.FC<{ detail: DetailType; full?: Boolean }> = ({
  detail,
  full = false,
}) => {
  // 路由钩子
  const router = useRouter();
  // 点击详情
  const handleDetail = async () => {
    const query = qs.stringify({ type: 1 });
    await router.push(`/news/detail/${detail?.id}?${query}`);
  };
  return (
    <NewsListWrap
      onClick={handleDetail}
      style={{ width: full ? '100%' : '86%' }}
    >
      <img
        className="item-image"
        src={detail?.surfaceImg}
        alt={detail?.newsTitle}
      />
      <div className="item-content">
        <div className="title">{detail?.newsTitle}</div>
        <div className="desc two-line-ellipsis">
          {detail?.newsContents?.match(/(?<=>)[^<>]+(?=<)/g)}
        </div>
        <div className="tips flex">
          <div className="text text-ellipsis" title={detail?.newsAuthor}>
            作者：{detail?.newsAuthor}
          </div>
          <div className="text text-ellipsis" title={detail?.origin}>
            来源：{detail?.origin}
          </div>
        </div>
      </div>
    </NewsListWrap>
  );
};

export default NewsListItem;
// 样式
const NewsListWrap = styled.div`
  position: relative;
  width: 86%;
  //width: 100%;
  box-sizing: border-box;
  margin: 0 auto 0.83rem;
  min-height: 9.17rem;
  background: #ffffff;
  box-shadow: 0 0.17rem 1rem 0 rgba(102, 120, 192, 0.11);
  border-radius: 0.5rem;
  display: flex;
  align-items: center;
  justify-content: flex-start;
  padding: 0 0.83rem;
  cursor: pointer;
  .item-image {
    width: 13.33rem;
    height: 7.5rem;
    border-radius: 0.25rem;
    object-fit: cover;
    margin-right: 1.67rem;
  }
  .item-content {
    position: relative;
    width: calc(100% - 15rem);
    min-height: 7.5rem;
    box-sizing: border-box;
    .title {
      font-weight: bold;
      font-size: 16px;
      margin-bottom: 0.5rem;
      &:hover {
        color: #ff552d;
      }
    }
    .desc {
      color: #666;
      margin-bottom: 0.83rem;
    }
    .tips {
      .text {
        width: 6.8rem;
      }
      .text:not(:last-child) {
        margin-right: 0.5rem;
      }
    }
  }
`;
