import request, { Response } from '~/api/request';

export interface DeviceListParams {
  categoryId?: any[];
  pageNo: number;
  pageSize: number;
  provinceId?: number;
  type: number;
}

export interface Goods {
  id: number;
  goodsName: string;
  images: string;
  price?: any;
}

export interface DeviceListResp {
  pageNo: 1;
  pageSize: 10;
  list: Array<Goods>;
  totalCount: 0;
  totalPage: 0;
}

export interface Ad {
  id: number;
  bannerImg: string;
}

export default {
  // web-商品信息-分页
  deviceList: (params: DeviceListParams, options = {}): Promise<Response<DeviceListResp>> => {
    return request('/pms/product/mall/deviceList', 'post', params, options);
  },
  // 产品商城广告位
  listBannerImg: () => {
    return request('/release/module/listBannerImg', 'get', {
      moduleCode: 'PRODUCT_MARKETP',
    });
  },
};
