import request, { Response } from '~/api/request';

export interface AllType {
  categoryName: string;
  id: number;
}

export interface FilterOptionResp {
  type: string;
  id: number;
  name: string;
}

export interface RegionResp {
  childInfo: RegionResp[] | null;
  id: number;
  level: number;
  name: string;
  pid: number;
}

export const equipmentLeasingApi = {
  deviceBrand: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/deviceBrand');
  },
  // deviceCategory: (): Promise<Response<Array<FilterOptionResp>>> => {
  //   return request("/pms/webDevice/category");
  // },
  deviceModel: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/deviceModel');
  },
};

export interface AppType {
  id: number;
  name: string;
  appName: string;
  createTime: string;
  type: string;
}

export interface IndustryType {
  id: number;
  industryIcon: string;
  name: string;
  shortName: string;
  industryType: string;
  propagate1: string;
  propagate2: string;
  image: string;
  video: string;
  type: string;
  appName: string;
}

export const jobServicesApi = {
  listAllAppType: (): Promise<Response<Array<AppType>>> => {
    return request('/release/work/listAllAppType');
  },
  listAllIndustry: (): Promise<Response<Array<IndustryType>>> => {
    return request('/release/work/listAllIndustry');
  },
};

export const mallApi = {
  listAllBrand: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/brand');
  },
  listAllCategory: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/category');
  },
  listAllParts: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/parts');
  },
  listAllModel: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webDevice/model');
  },
  listAllQuality: (): Promise<Response<Array<FilterOptionResp>>> => {
    return request('/pms/webProductMall/quality');
  },
};

export interface SkillsType {
  name: string;
  type: string;
  id: number;
  skillsName: string;
  licenseType: string;
}

export const flightSkillsApi = {
  IndustryFlightSkills: (): Promise<Response<Array<SkillsType>>> => {
    return request('/release/curriculum/getIndustryFlightSkills');
  },
  InDronePilotLicense: (): Promise<Response<Array<SkillsType>>> => {
    return request('/release/curriculum/getDronePilotLicense');
  },
};

export interface NewsPageType {
  id: number;
  newsTitle: string;
  newsAuthor: string;
  userAccountId: number;
  surfaceImg: string;
  newsContents: string;
  createTime: string;
  updateTime: string | null;
}

export interface NewsTenderType {
  id: number;
  tenderNewsId: number;
  tenderInfoNo: string;
  tenderContent: string;
  tenderPrice: number;
  createTime: string;
  apply: number;
  tenderTitle: string;
}

export interface ListPageNewsInfoResp {
  pageNo: number;
  pageSize: number;
  list: Array<NewsPageType>;
  totalCount: number;
  totalPage: number;
}

export interface ListTenderNewsInfoResp {
  pageNo: number;
  pageSize: number;
  list: Array<NewsTenderType>;
  totalCount: number;
  totalPage: number;
}

interface ListPageNewsInfoParams {
  pageNo: number;
  pageSize: number;
  cityCode?: number;
  date?: string;
  districtCode?: number;
  provinceCode?: number;
}

interface ListTenderNewsInfoParams {
  pageNo: number;
  pageSize: number;
  cityCode?: number;
  date?: string;
  districtCode?: number;
  provinceCode?: number;
}

export interface TenderApplyType {
  tenderInfoId: number;
  tenderNewsId: number;
  userAccountId: number;
}

export const listNewsApi = {
  // 新闻列表
  listNewsPage: (params: ListPageNewsInfoParams): Promise<Response<ListPageNewsInfoResp>> => {
    return request('/release/industry-news/listNewsPage', 'post', params);
  },
  // 招标列表
  listNewTenderInfo: (
    params: ListTenderNewsInfoParams,
  ): Promise<Response<ListTenderNewsInfoResp>> => {
    return request('/release/tender/listNewTenderInfo', 'post', params);
  },
  // web-招标-合作申请提交
  tenderApply: (params: TenderApplyType): Promise<Response<number>> => {
    return request('/release/tender/apply', 'post', params);
  },
};

export interface HomeCategoriesType {
  type: 1 | 2 | 3 | 4;
}
export interface ResHomeCategoriesType {
  id: number;
  categoryName: string;
}

export default {
  // 新闻列表
  HomeCategories: (params: HomeCategoriesType): Promise<Response<ResHomeCategoriesType>> => {
    return request('/pms/product/mall/getPageHomeCategories', 'get', params);
  },
};
