import request, { Response } from '~/api/request';

export interface ListCasePageParams {
  cityCode?: number;
  date?: string;
  districtCode?: number;
  pageNo: number;
  pageSize: number;
  provinceCode?: number;
}

export interface ListCasePageResp {
  pageNo: number;
  pageSize: number;
  list: Item[];
  totalCount: number;
  totalPage: number;
}

export interface Item {
  id: number;
  caseTitle: string;
  caseAuthor: string;
  userAccountId: number;
  surfaceImg: string;
  caseContents: string;
  createTime: string;
  updateTime: string;
}

export default {
  /**
   * 案例列表
   * @param params 
   * @returns 
   */
  listCasePage(params: ListCasePageParams, options = {}): Promise<Response<ListCasePageResp>> {
    return request('/release/industry-case/listCasePage', 'post', params, options);
  }
}