import React from "react";
import { Box } from "./styled";
import { Rate } from "antd";
import Image from "next/image";
import { JobDetail } from "../../api";

interface EvaluateType {
  evaluateInfo: Array<JobDetail>;
}

export default function Evaluate(props: EvaluateType) {
  const list = [{}, {}, {}, {}];
  const { evaluateInfo } = props;
  console.log(evaluateInfo);
  return (
    <Box>
      {evaluateInfo?.map((item, i) => (
        <div key={item.id} className="item">
          <div className="item-user">
            <div className="item-user-image">
              <Image
                className="image"
                height={42}
                width={42}
                src={item.img ? item.img : ""}
                alt="#"
              />
            </div>
            <div className="item-user-info">
              <div className="item-user-info-name">{item.star}</div>
              <Rate style={{ height: 30 }} disabled defaultValue={item.star} />
            </div>
          </div>
          <div className="item-content">
            <div className="item-content-label">{item.content}</div>
            <div className="item-content-image">
              {item.contentImgs?.map((item) => (
                <div key={item} className="image-item">
                  <Image width={80} height={80} src={item} alt="error" />
                </div>
              ))}
            </div>
            <div className="item-content-time">3月4日</div>
          </div>
        </div>
      ))}
    </Box>
  );
}
