import { Space, Select } from "antd";
import { useEffect, useState } from "react";
import styles from "../../index.module.scss";
import api, { RegionResp } from "../../api";

type Props = {
  onChange: (item: RegionResp) => void;
};

export default function RegionItem(props: Props) {
  const [provinceList, setProvinceList] = useState<RegionResp[]>([]);
  const [cityList, setCityList] = useState<RegionResp[]>([]);
  useEffect(() => {
    api.region().then((res) => {
      setProvinceList(res?.result || []);
    });
  }, []);

  const onProvinceChange = (value: number, item: any) => {
    console.log("省", value, item);
    setCityList(item.childInfo || []);
    props.onChange(item);
  };

  const onCityChange = (value: number, item: any) => {
    console.log("市", value);
    props.onChange(item);
  };
  return (
    <div className={styles.filterItem}>
      <div className={styles.filterItemTitle}>地域：</div>
      <div className={styles.filterItemMain}>
        <Space size={40}>
          <Select
            bordered={false}
            popupMatchSelectWidth={false}
            placeholder="选择省"
            onChange={onProvinceChange}
            options={provinceList.map((item) => {
              return {
                ...item,
                value: item.id,
                label: item.name,
              };
            })}
          />
          <Select
            bordered={false}
            popupMatchSelectWidth={false}
            placeholder="选择市"
            onChange={onCityChange}
            options={cityList.map((item) => {
              return {
                ...item,
                value: item.id,
                label: item.name,
              };
            })}
          />
        </Space>
      </div>
    </div>
  );
}
