import React from "react";
import { Empty } from "antd";
import { Box } from "./styled";
import { leftBoxProps } from "../interface";

export default function Left(props: leftBoxProps) {
  const { boxIndex, leftRenderDom, leftcontentstyle } = props;

  return (
    <div>
      {leftRenderDom.columns.map((item) => {
        if (item.noFor) {
          return item.element;
        }
        return null;
      })}
      {
        <Box index={boxIndex} leftcontentstyle={leftcontentstyle}>
          {leftRenderDom.columns.map((item) => {
            if (!item.noFor) {
              return item.element;
            }
            return null;
          })}
        </Box>
      }
      {!leftRenderDom.columns.length ? (
        <Empty description={"暂无数据"} />
      ) : null}
    </div>
  );
}
