import React from 'react';
import { ArrowRightOutlined } from '@ant-design/icons';
import { useRouter } from 'next/router';
import styled from 'styled-components';

const HomeHeadView = () => {
  // 路由钩子
  const router = useRouter();
  // 跳转详情
  const handleDetail = async () => {
    await router.push(`/store/product/39`);
  };
  return (
    <HomeHeadWrap>
      <div className="head-wrap">
        <img
          className="head-logo"
          src="https://file.iuav.com/file/sharefly-web-head-logo01.png"
          alt="科比特航空"
        />
        <div className="head-action flex-center" onClick={handleDetail}>
          <div className="text">进入商家</div>
          <ArrowRightOutlined />
        </div>
      </div>
    </HomeHeadWrap>
  );
};

export default HomeHeadView;
// 样式
const HomeHeadWrap = styled.div`
  position: relative;
  width: 100%;
  height: 16.42rem;
  background-image: url('https://file.iuav.com/file/sharefly-web-headbg02.png');
  //background-size: 100% 100%;
  background-size: cover;
  background-position: center;
  .head-wrap {
    position: relative;
    max-width: 1190px;
    height: 16.42rem;
    box-sizing: border-box;
    display: flex;
    align-items: flex-end;
    justify-content: center;
    flex-direction: column;
    margin: 0 auto;
    padding: 2rem 0 0 0;
    .head-logo {
      width: 18rem;
      object-fit: cover;
      margin-bottom: 2rem;
      user-select: none;
    }
    .head-action {
      width: 6rem;
      height: 2rem;
      background: #e1000e;
      border-radius: 0.38rem;
      color: #fff;
      cursor: pointer;
      &:hover {
        filter: brightness(0.96);
      }
      .text {
        margin-right: 0.25rem;
      }
    }
  }
`;
