import React, { Suspense } from "react";
import { Layout, Space } from "antd";
import NavHeader from "~/components/NavHeader";
import FooterView from "~/components/footer";
import {useRouter} from 'next/router'
import styles from './index.module.scss';

const { Header, Footer, Content } = Layout;
//底部栏固定定位
const includesPage = ["/home","/flyingHandService/detail/[id]"]

const homeStyle: React.CSSProperties = {
  marginTop:10
}

const headerStyle: React.CSSProperties = {
  height: "auto",
  background: "none",
  padding: 0,
  lineHeight: "1",
  position: "relative",
};

const contentStyle: React.CSSProperties = {
  minHeight: 120,
  lineHeight: "1",
  color: "",
  backgroundColor: "",
  width: 1200,
  position: "relative",
  margin: "0 auto",
};

const footerStyle: React.CSSProperties = {
  lineHeight: "1",
  padding: 0,
  position: "relative",
  marginTop: 60,
};

type Props = {
  children?: React.ReactNode;
  layoutStyle?: React.CSSProperties;
  contentStyle?: React.CSSProperties;
  hideFooter?: boolean;
  headerStyle?: React.CSSProperties
};

export default function LayoutView(props: Props) {
  const router = useRouter()
  return (
    <Space direction="vertical" style={{ minWidth: "100%" }} size={[0, 48]}>
      <Layout
        style={Object.assign(
          { minHeight: "100vh", backgroundColor: "#F8F8F8" },
          props.layoutStyle
        )}
      >
        <Header style={headerStyle}>
          <NavHeader style={props.headerStyle} />
        </Header>
        <Content className={styles.content} style={props.contentStyle}>
          {props.children}
        </Content>
        {!props.hideFooter && (
          <Footer
            style={
              includesPage.includes(router.pathname)
                ? { ...footerStyle, ...homeStyle }
                : footerStyle
            }
          >
            <FooterView></FooterView>
          </Footer>
        )}
      </Layout>
    </Space>
  );
}
