import styles from "./index.module.scss";
import Image from "next/image";

const qrcodeList = [
  {
    img: require("./assets/mmc.png"),
    title: "科比特官网",
    url: "http://www.mmcuav.cn/",
  },
  {
    img: require("./assets/fuwuhao.png"),
    title: "云享飞服务号",
  },
  {
    img: require("./assets/xiaochengxu.png"),
    title: "云享飞小程序",
  },
  {
    img: require("./assets/shequn.png"),
    title: "官方社群",
  },
];

export default function Footer() {
  return (
    <div className={styles.footer}>
      <div className={styles.footerBox}>
        <div className={styles.logo}></div>
        <div className={styles.qrcodeList}>
          {qrcodeList.map((item, i) => {
            return (
              <div className={styles.qrcodeItem} key={i}>
                <Image
                  style={{
                    cursor: item.title === "科比特官网" ? "pointer" : "",
                  }}
                  onClick={() => {
                    if (item.title === "科比特官网")
                      window.location.href = item.url!;
                  }}
                  alt=""
                  className={styles.qrcodeImg}
                  src={item.img}
                ></Image>
                <div className={styles.qrcodeTitle}>{item.title}</div>
              </div>
            );
          })}
        </div>
      </div>
      {/* <div className={styles.rightText}>
        <div className={styles.number}>100W</div>
        <div className={styles.text}>无人机新媒体矩阵等你来关注</div>
      </div> */}
    </div>
  );
}
