// user.ts
import { createSlice } from '@reduxjs/toolkit';
import { HYDRATE } from 'next-redux-wrapper';
import { InterDataType } from '@/api/interface';
import { ListInspectionPriceUnit } from '@/api/interface/service';
import { UserAddressSelectList } from '@/api/interface/user';

export type GlobalDataState = {
  loadingSpinnerVisible: boolean;
  loginModalVisible: boolean;
  loginModalTitle?: string;
  qrcodeModalVisible: boolean;
  qrcodeModalPath?: string;
  qrcodeModalScene?: string;
  userAddressList?: InterDataType<UserAddressSelectList>;
  userAddressSelectId?: number;
  productSpecNum?: number;
  priceUnitList?: InterDataType<ListInspectionPriceUnit>;
  toastModalVisible: boolean;
  toastModalBack: boolean;
};

const initialState: GlobalDataState = {
  loadingSpinnerVisible: false,
  loginModalVisible: false,
  qrcodeModalVisible: false,
  toastModalVisible: false,
  toastModalBack: false,
};

const globalDataSlice = createSlice({
  name: 'globalData',
  initialState,
  reducers: {
    setGlobalData: (state, action) => {
      return { ...state, ...action.payload };
    },
  },
  extraReducers: {
    // hydrated 用于获取服务端注入的state并选择更新
    [HYDRATE]: (state, action) => {
      return {
        ...state,
        ...action.payload.globalData,
      };
    },
  },
});

export const { setGlobalData } = globalDataSlice.actions;
export default globalDataSlice.reducer;
