import React from 'react';
import { Button } from 'antd';
import { FooterWrap } from '@/components/layout/footer/styled';
import QrcodePopover from '@/components/qrcodePopover';

const FooterView = () => {
  // 跳转外部网址
  const handleLink = (url: string) => {
    window.open(url);
  };
  // 关于列表
  const aboutList = [
    {
      img: '/assets/image/about/xiaochengxu.png',
      name: '云享飞小程序',
      alt: '云享飞小程序',
    },
    {
      img: '/assets/image/about/fuwuhao.png',
      name: '云享飞服务号',
      alt: '云享飞服务号',
    },
    {
      img: '/assets/image/about/shequn.png',
      name: '官方社群',
      alt: '官方社群',
    },
  ];
  // 集团列表
  const groupList = [
    { name: '浙江科比特', url: 'https://www.mmcuav.cn/' },
    {
      name: '更多产业布局',
      url: 'https://www.mmcuav.cn/about-mmc/industrial-layout/',
    },
  ];
  // 科比特航空
  const mmcList = [
    { name: '产品中心', url: 'https://www.mmcuav.cn/product-center/' },
    { name: '解决方案', url: 'https://www.mmcuav.cn/solution/' },
    // { name: '服务平台', url: 'https://www.mmcuav.cn/service-platform/' },
    // { name: '技术支持', url: 'https://www.mmcuav.cn/support/' },
    { name: '关于我们', url: 'https://www.mmcuav.cn/about-mmc/' },
  ];
  return (
    <FooterWrap>
      <div className="footer-wrap">
        <div className="footer-start">
          <div className="start-item">
            <div className="item-title">了解我们</div>
            <div className="item-content">
              云享飞是由杭州云享飞科技有限公司独立运营的无人机服务平台，云享飞为客户提供一站式的无人机需求服务，包括商品购买、设备租赁、发布订单等。
            </div>
          </div>
          <div className="start-item">
            <div className="item-title">集团公司</div>
            {groupList.map((i, j) => (
              <Button
                type={'link'}
                className="item-link"
                key={j}
                onClick={() => handleLink(i?.url)}
              >
                {i?.name}
              </Button>
            ))}
          </div>
          <div className="start-item">
            <div className="item-title">科比特航空</div>
            {mmcList.map((i, j) => (
              <Button
                type={'link'}
                className="item-link"
                key={j}
                onClick={() => handleLink(i?.url)}
              >
                {i?.name}
              </Button>
            ))}
          </div>
          <div className="start-item">
            <div className="item-title">加入云享飞</div>
            <QrcodePopover
              path={'page-identity/identity-list/index'}
              placement={'bottomLeft'}
            >
              <Button type={'link'} className="item-link">
                合作咨询
              </Button>
            </QrcodePopover>
            <QrcodePopover
              path={'page-identity/identity-list/index'}
              placement={'bottomLeft'}
            >
              <Button type={'link'} className="item-link">
                加盟政策
              </Button>
            </QrcodePopover>
          </div>
          <div className="start-item">
            <div className="item-title">关于我们</div>
            <div className="item-about">
              {aboutList?.map((i, j) => (
                <div className="about-item" key={j}>
                  <img src={i.img} alt={i.alt} className="item-logo" />
                  <div className="item-name">{i.name}</div>
                </div>
              ))}
            </div>
          </div>
        </div>
        <div className="footer-end">
          <QrcodePopover path={'page-mine/help-center/index'}>
            <Button type={'link'} className="end-item">
              常见问题
            </Button>
          </QrcodePopover>
          <QrcodePopover path={'page-mine/help-center/index'}>
            <Button type={'link'} className="end-item">
              意见反馈
            </Button>
          </QrcodePopover>
          <QrcodePopover path={'page-mine/sharefly-about/index'}>
            <Button type={'link'} className="end-item">
              免责声明
            </Button>
          </QrcodePopover>
          <Button
            type={'link'}
            className="end-item"
            onClick={() => {
              window.location.href = 'https://beian.miit.gov.cn';
            }}
          >
            浙ICP备2023014395号
          </Button>
        </div>
      </div>
    </FooterWrap>
  );
};

export default FooterView;
