import React from 'react';
import { Breadcrumb } from 'antd';
import { useRouter } from 'next/router';
import styled from 'styled-components';

const BreadcrumbWrap = styled.div`
  position: relative;
  width: 100%;
  display: flex;
  align-content: center;
  justify-content: flex-start;
  .title {
    font-size: 13px;
    font-weight: 400;
    color: #666666;
    margin-bottom: 0.75rem;
  }
  @media (prefers-color-scheme: dark) {
    .title {
      color: #fff;
    }
    .ant-breadcrumb {
      .ant-breadcrumb-separator {
        color: #d9d9d9;
      }
      .ant-breadcrumb-link {
        color: #d9d9d9;
      }
    }
  }
`;

const BreadcrumbView: React.FC = () => {
  // 路由钩子
  const router = useRouter();
  // 路由对应列表
  const routerList = [
    { name: '云享商城', path: 'mall' },
    { name: '行业服务', path: 'service' },
    { name: '设备租赁', path: 'rent' },
    { name: '执照培训', path: 'train' },
    { name: '飞手约单', path: 'flyer' },
    { name: '商品详情', path: 'product' },
    { name: '购物车', path: 'cart' },
    { name: '提交订单', path: 'submit' },
    { name: '服务详情', path: 'detail' },
  ];
  // 转换路由
  const getCurrentRouter = () => {
    const arr = router?.pathname
      ?.split('/')
      ?.map((i, j) => {
        const href = `/${router?.pathname
          .split('/')
          .slice(1, j + 1)
          .join('/')}`;
        const title = routerList?.find((n) => n.path === i)?.name;
        return { title, href };
      })
      ?.filter((i) => i.title); // 过滤掉没有title的项
    // 最后一项不跳转
    arr[arr.length - 1] = { title: arr[arr.length - 1]?.title, href: '' };
    return arr;
  };
  return (
    <BreadcrumbWrap>
      <div className="title">您的位置：</div>
      <Breadcrumb
        separator=">"
        items={[
          {
            title: '首页',
            href: '/',
          },
          ...getCurrentRouter(),
        ]}
      />
    </BreadcrumbWrap>
  );
};

export default BreadcrumbView;
