import request, { Response } from '~/api/request';

export interface ListPageFlyingInfoParams {
  id: number;
}

export interface Flying {
  id: number;
  price: number;
  supplierName: string;
  curriculumName: string;
  free: 0 | 1;
  curriculumDesc: string;
  videoUrl: string;
}

export interface ListPageFlyingInfoResp {
  id: number;
  price: number | null;
  supplierName: string;
  curriculumName: string;
  free: number;
  flightSkills: number;
  flightSkillsName1: string;
  flightSkillsName2: string;
  curriculumDesc: string;
  surfaceUrl: string | null;
  videoUrl: string;
  detailContent: null;
}

export default {
  //web-飞手培训-详情
  listPageJobServicesInfo: (
    params: ListPageFlyingInfoParams,
  ): Promise<Response<ListPageFlyingInfoResp>> => {
    return request('/release/curriculum/curriculumDetails', 'get', params);
  },
};
