import React, { createContext, Dispatch, SetStateAction, useState } from 'react';

export const CommonContext = createContext<{
  reloadRequirements: boolean; //更新项目需求列表
  setReloadRequirements: Dispatch<SetStateAction<boolean>>;
}>({
  reloadRequirements: false,
  setReloadRequirements: () => {},
});

type Props = {
  children: React.ReactNode;
};
const CommonProvider = ({ children }: Props) => {
  const [reloadRequirements, setReloadRequirements] = useState(false);

  return (
    <CommonContext.Provider
      value={{
        reloadRequirements,
        setReloadRequirements,
      }}
    >
      {children}
    </CommonContext.Provider>
  );
};

export default CommonProvider;
