import React, { useState } from 'react';
import ContentView from '@/components/layout/content';
import FooterView from '@/components/layout/footer';
import HeaderView from '@/components/layout/header';
import { LayoutWrap } from '@/components/layout/styled';
import QrcodeModalView from '@/components/qrcodeModal';

const LayoutView = ({ children }: { children?: React.ReactNode }) => {
  // 打开二维码弹窗
  const [qrcodeShow, setQrcodeShow] = useState<boolean>(false);

  return (
    <div className={'animate__animated animate__faster animate__fadeIn'}>
      <LayoutWrap>
        <div
          onClick={() => {
            setQrcodeShow(!qrcodeShow);
          }}
        >
          <HeaderView></HeaderView>
          <ContentView>{children}</ContentView>
          <FooterView></FooterView>
        </div>
        <QrcodeModalView
          open={qrcodeShow}
          onCancel={() => setQrcodeShow(false)}
        />
      </LayoutWrap>
    </div>
  );
};

export default LayoutView;
