import React, { useEffect } from 'react';
import { EnvironmentFilled } from '@ant-design/icons';
import { Button } from 'antd';
import { useRouter } from 'next/router';
import { HeaderWrap } from '@/components/layout/header/styled';

const HeaderView: React.FC<{
  placeholder?: boolean;
}> = ({ placeholder }) => {
  HeaderView.defaultProps = {
    placeholder: true,
  };
  // 当前的路由数据
  const router = useRouter();
  // 组件挂载
  useEffect(() => {
    console.log('HeaderView --->', router);
  }, [router]);
  return (
    <HeaderWrap>
      <div className="header-wrap">
        <div className="header-location">
          <div className="location-icon">
            <EnvironmentFilled
              style={{ color: '#FF552D', fontSize: '0.86rem' }}
            />
          </div>
          <Button type={'link'} className="location-address">
            杭州
          </Button>
          <div className="location-hello">Hi，欢迎来云享飞</div>
        </div>
        <div className="header-nav">
          <div className="nav-tab">
            <Button type={'link'} className="tab-item">
              个人中心
            </Button>
            <Button type={'link'} className="tab-item">
              购物车
            </Button>
            <Button type={'link'} className="tab-item">
              我的订单
            </Button>
            <Button type={'link'} className="tab-item">
              消息
            </Button>
            <Button type={'link'} className="tab-item">
              联系客服
            </Button>
          </div>
          <div className="nav-action">
            <Button type={'primary'} className="action-item">
              登录
            </Button>
            <Button type={'primary'} className="action-item">
              发布需求
            </Button>
            <Button type={'primary'} className="action-item">
              加盟入驻
            </Button>
          </div>
        </div>
      </div>
    </HeaderWrap>
  );
};

export default HeaderView;
