import React, { useEffect, useState } from 'react';
import LayoutView from '@/components/layout';
import HomeView from '@/pages/home';

const App = () => {
  // 定义一个状态变量，用于存储滚动距离
  const [scrollY, setScrollY] = useState(0);
  // 定义一个副作用函数，用于获取滚动距离并更新状态
  const handleScroll = () => {
    // 获取滚动距离，兼容多种浏览器
    const scrollTop =
      document.documentElement.scrollTop ||
      window.pageYOffset ||
      document.body.scrollTop;
    // 更新状态
    setScrollY(scrollTop);
  };
  // 使用 useEffect 钩子来添加和移除滚动事件的监听器
  useEffect(() => {
    // 组件挂载后，添加监听器
    window.addEventListener('scroll', handleScroll);
    // 组件卸载前，移除监听器
    return () => {
      window.removeEventListener('scroll', handleScroll);
    };
  }, []); // 依赖数组为空，表示只执行一次
  return (
    <LayoutView placeholder={scrollY >= 200}>
      <HomeView></HomeView>
    </LayoutView>
  );
};

export default App;
