import React from 'react';
import {
  ExportOutlined,
  LikeOutlined,
  MessageOutlined,
} from '@ant-design/icons';
import { Image } from 'antd';
import styled from 'styled-components';
import { InterListType } from '@/api/interface';
import { ForumListType } from '@/api/interface/home';

// 详情类型
type DetailType = InterListType<ForumListType>[0];

const ForumItemView: React.FC<{ detail: DetailType }> = ({ detail }) => {
  // 获取帖子的媒体信息 0图片 1视频
  const getForumMedia = (type: number) => {
    return detail?.mediaVO?.filter((i) => i?.type === type)?.slice(0, 4);
  };
  // 帖子相关操作
  const handleAction = (type: number) => {
    console.log(type);
  };
  return (
    <ForumItemWrap>
      <div className="relative mb-2 flex w-full items-center justify-start">
        <img
          className="h-9 w-9 rounded-full"
          src={detail?.userBaseInfo?.userImg}
          alt="头像"
        />
        <div className="ml-2">
          <div className="font-bold">
            {detail?.userBaseInfo?.nickName || '微信用户'}
          </div>
          <div className="text-aaa">{detail?.dynamicPublishTime}</div>
        </div>
      </div>
      <div className="mb-3 w-full leading-5 tracking-wide">
        {detail?.forumGambitDTOList?.map((i, j) => (
          <span key={j} className="mr-1·cursor-pointer·font-bold·text-tag">
            {i.gambitName}
          </span>
        ))}
        <span>{detail?.description}</span>
      </div>
      <div className="forum-media flex w-full flex-wrap items-start justify-start">
        {getForumMedia(0)?.length
          ? getForumMedia(0)?.map((i, j) => (
              <Image src={i.url} alt="图片" key={j} />
            ))
          : undefined}
        {getForumMedia(1)?.length
          ? getForumMedia(1)?.map((i, j) => (
              <div
                className="media-video relative box-border overflow-hidden rounded-lg"
                key={j}
              >
                {/* eslint-disable-next-line jsx-a11y/media-has-caption */}
                <video src={i.url} controls={true} />
              </div>
            ))
          : undefined}
      </div>
      <div className="forum-action flex pb-2 text-777">
        <div className="action-item mr-8 flex" onClick={() => handleAction(1)}>
          <LikeOutlined />
          <div className="ml-1">{detail?.likesCount}</div>
        </div>
        <div className="action-item mr-8 flex" onClick={() => handleAction(2)}>
          <MessageOutlined />
          <div className="ml-1">{detail?.commentCount}</div>
        </div>
        <div className="action-item mr-8 flex" onClick={() => handleAction(3)}>
          <ExportOutlined />
          <div className="ml-1">{detail?.transpond}</div>
        </div>
      </div>
    </ForumItemWrap>
  );
};

export default ForumItemView;
// 样式
const ForumItemWrap = styled.div`
  position: relative;
  width: 100%;
  box-sizing: border-box;
  margin-bottom: 1rem;
  .forum-media {
    .media-video {
      width: 500px;
      height: calc(500px / 16 * 9);
      margin-bottom: 1rem;
      video {
        width: 100%;
        height: 100%;
      }
    }
  }
  .forum-action {
    .action-item {
      cursor: pointer;
      &:hover {
        color: #ff552d;
      }
    }
  }
  .ant-image {
    width: calc((100% - 0.67rem * 3) / 4);
    height: 8.6rem;
    margin: 0 0.67rem 0.67rem 0;
    border-radius: 0.5rem;
    overflow: hidden;
    &:nth-child(4n) {
      margin-right: 0;
    }
    .ant-image-img {
      object-fit: cover;
      height: 8.6rem;
    }
  }
`;
