import React, { useEffect, useState } from "react";
import { Button, Select, Space, Tag } from "antd";
import Layout from "~/components/layout";
import styles from "./index.module.scss";

export default function Mall() {
  const [productList, setProductList] = useState(Array<{}>);

  useEffect(() => {
    setProductList([{}, {}, {}, {}, {}, {}]);
  }, []);

  const onProvinceChange = (value: string) => {
    console.log("省", value);
  };

  const onCityChange = (value: string) => {
    console.log("市", value);
  };

  const onMoreChange = (value: string) => {
    console.log("更多", value);
  };

  const onCloseTag = (e: React.MouseEvent<HTMLElement, MouseEvent>) => {
    console.log("删除", e);
  };

  return (
    <Layout>
      <div className="page" style={{ paddingTop: "29px" }}>
        <div className="filter-wrap" style={{ marginBottom: "11px" }}>
          <div className="filter-item">
            <div className="filter-item__title">地域：</div>
            <div className="filter-item-main">
              <Space size={40}>
                <Select
                  bordered={false}
                  dropdownMatchSelectWidth={false}
                  placeholder="选择省"
                  onChange={onProvinceChange}
                  options={[
                    { value: "jack", label: "Jack" },
                    { value: "lucy", label: "Lucy" },
                    { value: "Yiminghe", label: "yiminghe" },
                    { value: "disabled", label: "Disabled", disabled: true },
                  ]}
                />
                <Select
                  bordered={false}
                  dropdownMatchSelectWidth={false}
                  placeholder="选择市"
                  onChange={onCityChange}
                  options={[
                    { value: "jack", label: "Jack" },
                    { value: "lucy", label: "Lucy" },
                    { value: "Yiminghe", label: "yiminghe" },
                    { value: "disabled", label: "Disabled", disabled: true },
                  ]}
                />
              </Space>
            </div>
          </div>
        </div>
        <div className="filter-wrap">
          <div className="filter-item">
            <div className="filter-item__title">类目：</div>
            <div className="filter-item-main">
              <Space size={40}>
                <Button type="link">不限</Button>
                <Button type="link">无人机</Button>
                <Button type="link">挂载</Button>
                <Button type="link">地面站</Button>
              </Space>
              <Select
                placeholder="更多"
                onChange={onMoreChange}
                bordered={false}
                dropdownMatchSelectWidth={false}
                options={[
                  { value: "jack", label: "Jack" },
                  { value: "lucy", label: "Lucy" },
                  { value: "Yiminghe", label: "yiminghe" },
                  { value: "disabled", label: "Disabled", disabled: true },
                ]}
              />
            </div>
          </div>
          <div className="filter-item">
            <div className="filter-item__title">品牌：</div>
            <div className="filter-item-main">
              <Space size={40}>
                <Button type="link">不限</Button>
                <Button type="link">无人机</Button>
                <Button type="link">挂载</Button>
                <Button type="link">地面站</Button>
              </Space>
              <Select
                placeholder="更多"
                onChange={onMoreChange}
                bordered={false}
                dropdownMatchSelectWidth={false}
                options={[
                  { value: "jack", label: "Jack" },
                  { value: "lucy", label: "Lucy" },
                  { value: "Yiminghe", label: "yiminghe" },
                  { value: "disabled", label: "Disabled", disabled: true },
                ]}
              />
            </div>
          </div>
          <div className="filter-item">
            <div className="filter-item__title">部件：</div>
            <div className="filter-item-main">
              <Space size={40}>
                <Button type="link">不限</Button>
                <Button type="link">无人机</Button>
                <Button type="link">挂载</Button>
                <Button type="link">地面站</Button>
              </Space>
              <Select
                placeholder="更多"
                onChange={onMoreChange}
                bordered={false}
                dropdownMatchSelectWidth={false}
                options={[
                  { value: "jack", label: "Jack" },
                  { value: "lucy", label: "Lucy" },
                  { value: "Yiminghe", label: "yiminghe" },
                  { value: "disabled", label: "Disabled", disabled: true },
                ]}
              />
            </div>
          </div>
          <div className="filter-item">
            <div className="filter-item__title">型号：</div>
            <div className="filter-item-main">
              <Space size={40}>
                <Button type="link">不限</Button>
                <Button type="link">无人机</Button>
                <Button type="link">挂载</Button>
                <Button type="link">地面站</Button>
              </Space>
              <Select
                placeholder="更多"
                onChange={onMoreChange}
                bordered={false}
                dropdownMatchSelectWidth={false}
                options={[
                  { value: "jack", label: "Jack" },
                  { value: "lucy", label: "Lucy" },
                  { value: "Yiminghe", label: "yiminghe" },
                  { value: "disabled", label: "Disabled", disabled: true },
                ]}
              />
            </div>
          </div>
          <div className="filter-item">
            <div className="filter-item__title">成色：</div>
            <div className="filter-item-main">
              <Space size={40}>
                <Button type="link">不限</Button>
                <Button type="link">无人机</Button>
                <Button type="link">挂载</Button>
                <Button type="link">地面站</Button>
              </Space>
            </div>
          </div>
          <div className="filter-item">
            <div className="filter-item__title">已选：</div>
            <div className="filter-item-main">
              <Space size={10}>
                <Tag closable onClose={onCloseTag}>
                  无人机
                </Tag>
                <Tag closable onClose={onCloseTag}>
                  无人机
                </Tag>
              </Space>
            </div>
          </div>
        </div>
        <div className={styles.productList}>
          <div className={styles.title}>四旋翼无人机</div>
          <div className={styles.main}>
            <ul className={styles.listWrap}>
              {productList.map((item) => {
                return (
                  <li className={styles.item}>
                    <img className={styles.img}></img>
                    <div className={styles.title}>
                      入云龙ll 1550入云龙ll 1550入云龙ll 1550入云龙ll 1550
                    </div>
                    <div className={styles.sellCount}>半年售12987</div>
                  </li>
                );
              })}
            </ul>
            <div className={styles.ad}></div>
          </div>
        </div>
      </div>
    </Layout>
  );
}
