import styled from "styled-components"
let one = require("./assets/icon.png")

export const Box = styled.div`
    box-sizing: border-box;
    padding-top: 24px;
    width: 1200px;
    margin: 0 auto;
    .item{
        height:343px;
        transition: all .5s;
        cursor: pointer;
        &-title{
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 25px;
            height: 75px;
            background: #FFFFFF;
            box-shadow: 10px 10px 20px 0px rgba(228,228,228,0.3);
            border-radius: 6px 6px 0px 0px ;
            .item-left{
                display: flex;
                justify-content: space-around;
                align-items: center;
                width:150px;
                &-icon{
                    width: 40px;
                    height: 40px;
                }
                &-label{
                    width: 100px;
                    height: 32px;
                    font-size: 20px;
                    font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
                    font-weight: bold;
                    color: #000000;
                    line-height: 32px;
                }
            }
        }
        &-body{
            padding-left: 10px;
            height: 268px;
            background: #FFFFFF;
            box-shadow: 10px 10px 20px 0px rgba(228,228,228,0.3);
            border-radius: 0px 0px 6px 6px;
            .item-bubble{
                /* width: 80px; */
                padding: 0 5px;
                height: 32px;
                line-height: 32px;
                background: #F4F6F9;
                border-radius: 19px;
                text-align: center;
                cursor: pointer;
                &.active{
                    color: #FF552D;
                }
            }
        }
        &:hover{
            box-shadow: 20px 20px 10px 0px rgba(228,228,228,1);
        }
    }
    .right-item{
        height: 344px;
        background-color: #fff;
        .title{
            display: flex;
            align-items: center;
            padding: 0 25px;
            height: 60px;
            width: 80px;
            font-size: 20px;
            font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
            font-weight: bold;
            color: #000000;
            line-height: 25px;
        }
        .body{
            height: 284px;
            overflow-y: auto;
            &-item{
                display: flex;
                justify-content: space-between;
                align-items: center;
                height: 70px;
                padding: 0 20px;
                .item-label{
                    width: 217px;
                    height: 40px;
                    font-size: 16px;
                    font-family: MicrosoftYaHei;
                    color: #323232;
                    line-height: 21px;
                    word-wrap: break-word;
                }
                .item-image{
                    width: 96px;
                    height: 60px;
                    background: #D8D8D8;
                    border-radius: 6px;
                }
            }
        }
    }
    .right-item-second{
        height: 510px;
        background-color: #fff;
        .title{
            display: flex;
            align-items: center;
            padding: 0 25px;
            height: 62px;
            width: 80px;
            font-size: 20px;
            font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
            font-weight: bold;
            color: #000000;
            line-height: 25px;
        }
        .body{
            height: 448px;
            overflow-y: auto;
            &-item{
                display: flex;
                justify-content: space-between;
                align-items: center;
                height: 88px;
                padding: 0 20px;
                .item-label{
                    width: 217px;
                    height: 40px;
                    font-size: 16px;
                    font-family: MicrosoftYaHei;
                    color: #323232;
                    line-height: 21px;
                    word-wrap: break-word;
                    .label-top{
                    }
                    .label-bottom{
                        font-size: 15px;
                        font-family: PingFangSC-Medium, PingFang SC;
                        font-weight: 500;
                        color: #FF552D;
                    }
                }
                .item-right{
                    .btn{
                        text-align: center;
                        background: #FF552D;
                        border-radius: 14px;
                        font-size: 14px;
                        font-family: MicrosoftYaHei;
                        color: #FFFFFF;
                    }
                }
            }
        }
    }
`