import styled from "styled-components"

export const Box = styled.div`
    box-sizing: border-box;
    width: 1200px;
    .flyingTop{
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 15px 0;
        width: 925px;
        &-left{
          .selectItem{
            width: 120px;
            background-color: #fff;
            border-radius: 5px;
          }  
        }
        .btn {
            width: 220px;
            height: 60px;
            background: linear-gradient(90deg, #278eff 0%, #0052da 100%);
            border-radius: 6px;
            border: 0;
            font-size: 16px;
            font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
            font-weight: bold;
            color: #ffffff;
            &:hover {
                opacity: 0.8;
            }
        }
    }
    .item{
      width: 220px;
      height: 320px;
      cursor: pointer;
      transition: all .5s;
      background-color: #fff;
      border-radius: 6px;
      &-top{
        width: 220px;
        height: 160px;
        background-color: #E6E6E6;
        border-radius: 6px 6px 0px 0px;
      }
      &-bottom{
        height: 160px;
        padding: 9px 12px 20px;
        border-radius: 0px 0px 6px 6px;
        background-color: #fff;
        .bottom-title{
          width: 196px;
          height: 44px;
          font-size: 15px;
          font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
          font-weight: bold;
          color: #34383F;
          line-height: 22px;
          -webkit-background-clip: text;
        }
        .bottom-details{
          width: 192px;
          height: 44px;
          font-size: 12px;
          font-family: MicrosoftYaHei;
          color: #828A92;
          line-height: 22px;
          //超出两行隐藏
          overflow: hidden;
          text-overflow: ellipsis;
          display: -webkit-box;
          -webkit-line-clamp: 2;
          -webkit-box-orient: vertical;
        }
        .bottom-price{
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 14px;
            &-left{
              width: 100px;
              height: 26px;
              line-height: 26px;
              background: #E7EEFF;
              border-radius: 12px;
              text-align: center;
              font-size: 14px;
              font-family: MicrosoftYaHei;
              color: #4280F9;
            }
            &-right{
              .price-right-label {
                width: 36px;
                height: 22px;
                font-size: 18px;
                font-family: MicrosoftYaHeiUI-Bold, MicrosoftYaHeiUI;
                font-weight: bold;
                color: #FF552D;
                line-height: 22px;
              }
              .price-right-money {
                margin-left: 5px;
                width: 36px;
                height: 16px;
                font-size: 12px;
                font-family: MicrosoftYaHei;
                color: #8790A2;
                line-height: 16px;
                -webkit-background-clip: text;
              }
            }
        }
      }
      &:hover{
            box-shadow: 20px 20px 10px 0px rgba(228,228,228,1);
        }
    }
    .right-item{
      width: 260px;
      height: 420px;
      background: #FFFFFF;
      border-radius: 6px;
    }
`