import React, { useEffect, useState } from 'react';
import { Menu, MenuProps } from 'antd';
import styled from 'styled-components';
import { InterDataType } from '@/api/interface';
import { AppCategoryInfoType } from '@/api/interface/home';

// 分类类型
type CategoryType = InterDataType<AppCategoryInfoType>;

const StoreProductMenuView: React.FC<{
  category: CategoryType;
  current: number;
  onCurrent: (index: number) => void;
  onSelect: ({ main, second }: { main?: number; second?: number[] }) => void;
}> = ({ category, current, onSelect, onCurrent }) => {
  // 菜单数据
  const [items, setItems] = useState<MenuProps['items']>();
  // 当前选项
  const [selectedKeys, setSelectedKeys] = useState<MenuProps['selectedKeys']>();
  // 转换菜单数据
  const transMenuList = () => {
    setItems(
      category?.map((i, _j) => ({
        label: i?.name,
        key: String(i?.id),
        children: i?.subDTOList?.map((n, _m) => ({
          label: n?.name,
          key: n?.id,
        })),
      })),
    );
  };
  // 获取当前默认选择的选项
  const getSelectedKeys = () => {
    const index = category?.[current]?.id;
    setSelectedKeys([String(index)]);
    onSelect?.({
      main: Number(index),
      second: category
        ?.find((i) => i?.id === index)
        ?.subDTOList?.map((i) => i?.id),
    });
  };
  // 选项展开
  const handleOpen: MenuProps['onOpenChange'] = (e) => {
    const select = e?.at(-1) || selectedKeys?.[0];
    const index = category?.findIndex((i) => String(i?.id) === select);
    setSelectedKeys([String(select)]);
    onCurrent?.(index);
  };
  // 筛选事件
  const handleSelect: MenuProps['onSelect'] = (e) => {
    setSelectedKeys(e.keyPath);
    onSelect?.({
      main: Number(e?.keyPath?.[0]),
      second: [Number(e?.key)],
    });
  };
  // 组件挂载
  useEffect(() => {
    transMenuList();
  }, []);
  // 副作用
  useEffect(() => {
    getSelectedKeys();
  }, [current]);
  return (
    <StoreProductMenuWrap>
      <div className="menu-head">商品分类</div>
      {items && (
        <Menu
          selectedKeys={selectedKeys}
          openKeys={selectedKeys}
          mode={'inline'}
          items={items}
          onSelect={handleSelect}
          onOpenChange={handleOpen}
        />
      )}
    </StoreProductMenuWrap>
  );
};

export default StoreProductMenuView;
// 样式
const StoreProductMenuWrap = styled.div`
  position: relative;
  width: 20%;
  box-sizing: border-box;
  border: 1px solid #e5e5e5;
  border-top: none;
  margin-bottom: 10rem;
  //background: lightpink;
  .menu-head {
    width: 100%;
    height: 2rem;
    background: #2f2f2f;
    font-weight: 400;
    color: #ffffff;
    box-sizing: border-box;
    line-height: 2rem;
    padding-left: 0.5rem;
  }
`;
