import React from 'react';
import { Input, Rate } from 'antd';
import styled from 'styled-components';
import { InterDataType } from '@/api/interface';
import { GetCompanyInfoByBUId } from '@/api/interface/mall';
import QrcodeView from '@/components/qrcodeView';

// 详情类型
type DetailType = InterDataType<GetCompanyInfoByBUId>;

const StoreProductHeadView: React.FC<{ detail: DetailType }> = ({ detail }) => {
  return (
    <StoreProductHeadWrap className="flex-center select-none">
      <div className="head-image">
        <img
          className="image"
          src={detail?.brandLogo}
          alt={detail?.companyName}
        />
      </div>
      <div className="head-content">
        <div className="title mb-1">
          <span className="text-777">店铺：</span>
          {detail?.fullName || detail?.companyName || detail?.brandName}
        </div>
        <div className="star flex-start mb-1">
          <div className="label">服务星级</div>
          <Rate
            disabled
            defaultValue={Number(detail?.score) || 4}
            className="text-xs text-primary"
          />
        </div>
        <div className="text text-ellipsis text-[#666]">{detail?.content}</div>
      </div>
      <div className="head-search">
        <Input.Search
          className="search-box"
          placeholder="科比特航空"
          enterButton="搜索"
          size={'large'}
          bordered={true}
        />
      </div>
      <div className="head-qrcode">
        <QrcodeView
          path={`page-product/product-store/index`}
          scene={`id=${detail?.id}`}
        />
      </div>
      <div className="head-text text-777">扫码进入小程序店铺</div>
    </StoreProductHeadWrap>
  );
};

export default StoreProductHeadView;
// 样式
const StoreProductHeadWrap = styled.div`
  position: relative;
  width: 100%;
  box-sizing: border-box;
  background: white;
  padding: 0.5rem 0;
  //min-height: 4.78rem;
  .head-image {
    position: relative;
    width: 3.5rem;
    height: 3.5rem;
    margin-right: 0.75rem;
    .image {
      width: 100%;
      height: 100%;
      object-fit: cover;
    }
  }
  .head-content {
    margin-right: 10rem;
    .star {
      .label {
        margin-right: 0.5rem;
        background: #fff2ee;
        border-radius: 0.1rem;
        border: 0.02rem solid #ff6242;
        font-weight: 400;
        font-size: 0.65rem;
        color: #ff522f;
        box-sizing: border-box;
        padding: 0 0.25rem;
      }
    }
  }
  .head-search {
    position: relative;
    width: 24rem;
    box-sizing: border-box;
    margin-right: 10rem;
  }
  .head-qrcode {
    position: relative;
    width: 3.78rem;
    height: 3.78rem;
    margin-right: 1rem;
  }
`;
