import React from 'react';
import { InterListType } from '@/api/interface';
import { GetIndustryListPagesType } from '@/api/interface/service';
import { ServiceAPI } from '@/api/modules/service';
import ServiceView from '@/components/service-comp';
import { wrapper } from '@/store';
import { setGlobalData } from '@/store/module/globalData';

// 分类列表类型
type CategoryListType = InterListType<GetIndustryListPagesType>;

// 使用wrapper.getServerSideProps高阶函数包裹getServerSideProps函数
export const getServerSideProps = wrapper.getServerSideProps(
  (store) => async () => {
    // 分类数据
    let categoryList: CategoryListType = [];
    // 获取各个目录及分类信息
    const getIndustryListPages = async () => {
      const res = await ServiceAPI.getIndustryListPages({
        pageNo: 1,
        pageSize: 999,
      });
      if (res && res.code === '200') {
        categoryList = res?.result?.list || [];
      }
    };
    // 获取价格单位列表
    const getPriceUnitList = async () => {
      const res = await ServiceAPI.listInspectionPriceUnit();
      if (res && res.code === '200') {
        store.dispatch(setGlobalData({ priceUnitList: res?.result || [] }));
      }
    };
    // 依次获取接口数据
    await (async () => {
      await Promise.all([getIndustryListPages(), getPriceUnitList()]);
    })();
    return { props: { categoryList } };
  },
);

const ServicePageView: React.FC<{
  categoryList: CategoryListType;
}> = (props) => <ServiceView {...props} />;

export default ServicePageView;
