import React, { useEffect, useState } from 'react';
import { RightOutlined } from '@ant-design/icons';
import { useRouter } from 'next/router';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterListType } from '@/api/interface';
import { GetAppGambitListType } from '@/api/interface/home';

// 列表类型
type ListType = InterListType<GetAppGambitListType>;
// 帖子类型
const indexList = [
  { label: 1, value: 'text-[#FF3A2C]' },
  { label: 2, value: 'text-[#FE7A2C]' },
  { label: 3, value: 'text-[#FEA32C]' },
];

const HomeTopicView: React.FC = () => {
  // 路由钩子
  const router = useRouter();
  // 话题列表
  const [topicList, setTopicList] = useState<ListType>();
  // 获取话题列表
  const getListGambit = async () => {
    const res = await HomeAPI.getAppGambitList({
      pageNo: 1,
      pageSize: 6,
    });
    if (res && res.code === '200') {
      setTopicList(res.result?.list || []);
      // console.log('获取话题列表 --->', res.result?.list);
    }
  };
  // 跳转详情
  const handleDetail = async (item: ListType[0]) => {
    await router.push(`/forum/topic/${item.id}`);
  };
  // 组件挂载
  useEffect(() => {
    getListGambit().then();
  }, []);
  return (
    <HomeTopicWrap>
      <div className="topic-head flex-between">
        <div className="label flex-start select-none">
          <img
            className="icon"
            src="https://file.iuav.com/file/sharefly-home-comp-icon-03.png"
            alt="热门课程"
          />
          <div className="text">热门话题</div>
        </div>
        <div className="more flex-end cursor-pointer">
          <div className="text">更多</div>
          <RightOutlined />
        </div>
      </div>
      <div className="topic-list">
        {topicList?.map((i, j) => (
          <div
            key={j}
            className="flex-between list-item list-none"
            onClick={() => handleDetail(i)}
          >
            <div className="item-title flex-start">
              <div
                className={`${indexList[j]?.value || 'text-[#c3c3c3]'} index`}
              >
                {j + 1}
              </div>
              <div className="title">{i.gambitName}</div>
            </div>
            <div className="item-num">{i?.postCount}个帖子</div>
          </div>
        ))}
      </div>
    </HomeTopicWrap>
  );
};

export default HomeTopicView;
// 样式
const HomeTopicWrap = styled.div`
  position: relative;
  width: 100%;
  margin: 0 0 1rem 0;
  box-sizing: border-box;
  .topic-head {
    position: relative;
    box-sizing: border-box;
    width: 100%;
    margin-bottom: 0.67rem;
    .label {
      .icon {
        width: 2rem;
        height: 2rem;
      }
      .text {
        font-weight: 550;
        font-size: 1rem;
        color: #333333;
      }
    }
    .more {
      color: #ff552d;
    }
  }
  .topic-list {
    position: relative;
    width: 100%;
    box-sizing: border-box;
    .list-item {
      position: relative;
      width: 100%;
      height: 2rem;
      box-sizing: border-box;
      cursor: pointer;
      background: #fff;
      padding: 0 0.25rem 0 0.5rem;
      &:hover {
        filter: brightness(0.96);
      }
      .item-title {
        align-items: baseline;
        .index {
          font-weight: 500;
          font-size: 14px;
          margin-right: 0.67rem;
        }
        .title {
          font-weight: 400;
          font-size: 13px;
          color: #333333;
          &:hover {
            color: #ff552d;
          }
        }
      }
      .item-num {
        font-weight: 400;
        font-size: 12.5px;
        color: #999999;
      }
    }
  }
`;
