import React, { useEffect, useState } from 'react';
import { RightOutlined } from '@ant-design/icons';
import styled from 'styled-components';
import { HomeAPI } from '@/api';
import { InterListType } from '@/api/interface';
import { AppListPilotType } from '@/api/interface/home';

// 列表类型
type ListType = InterListType<AppListPilotType>;

const HomeFlyerView: React.FC = () => {
  // 飞手列表
  const [flyerList, setFlyerList] = useState<ListType>();
  // 获取飞手列表
  const getFlyerList = async () => {
    const res = await HomeAPI.appListPilot({
      // 审批通过
      auditStatus: 1,
      pageNo: 1,
      pageSize: 20,
    });
    if (res && res.code === '200') {
      const list = res.result?.list || [];
      setFlyerList(
        Array.from(
          { length: list.length < 2 ? list.length : 2 },
          () => list.splice(Math.floor(Math.random() * list.length), 1)[0],
        ),
      );
      // console.log('获取飞手列表 --->', flyerList.value)
    }
  };
  // 组件挂载
  useEffect(() => {
    getFlyerList().then();
  }, []);
  return (
    <HomeFlyerWrap>
      <div className="flyer-head flex-between">
        <div className="label flex-start select-none">
          <img
            className="icon"
            src="https://file.iuav.com/file/sharefly-home-comp-icon-01.png"
            alt="本地飞手"
          />
          <div className="text">本地飞手</div>
        </div>
        <div className="more flex-end cursor-pointer">
          <div className="text">更多</div>
          <RightOutlined />
        </div>
      </div>
      <div className="flyer-list">
        {flyerList?.map((i, j) => <FlyerItemView key={j} detail={i} />)}
      </div>
    </HomeFlyerWrap>
  );
};

export default HomeFlyerView;
// 样式
const HomeFlyerWrap = styled.div`
  position: relative;
  width: 100%;
  margin: 1rem 0 2rem 0;
  box-sizing: border-box;
  .flyer-head {
    position: relative;
    box-sizing: border-box;
    width: 100%;
    //margin-bottom: 0.67rem;
    .label {
      .icon {
        width: 2rem;
        height: 2rem;
      }
      .text {
        font-weight: 550;
        font-size: 1rem;
        color: #333333;
      }
    }
    .more {
      color: #ff552d;
    }
  }
  .flyer-list {
    position: relative;
    width: 100%;
    box-sizing: border-box;
  }
`;

// 子组件
const FlyerItemView: React.FC<{ detail: ListType[0] }> = ({ detail }) => {
  return (
    <FlyerItemWrap>
      <div className="left">
        <img
          className="image"
          src={`${detail?.userImg}?x-oss-process=image/quality,q_10`}
          alt={detail?.userName}
        />
        {!!detail?.userStateVO?.state && (
          <div className="state">{detail?.userStateVO?.state}</div>
        )}
      </div>
      <div className="right">
        <div className="title">{detail?.userName}</div>
        <div className="text">
          <span className="city">{detail?.residentCity}</span>
          <span>{detail?.yearsOfWorking}年经验</span>
        </div>
        <div className="tag flex-start">
          {detail?.pilotAbility?.map((i, j) => (
            <div className="item" key={j}>
              {i?.abilityName}
            </div>
          ))}
        </div>
        <div className="desc text-ellipsis" title={detail?.individualResume}>
          {detail?.individualResume}
        </div>
      </div>
      <div className="action">个人主页</div>
    </FlyerItemWrap>
  );
};
// 子组件样式
const FlyerItemWrap = styled.div`
  position: relative;
  width: 100%;
  min-height: 6.2rem;
  box-sizing: border-box;
  display: flex;
  align-items: flex-start;
  justify-content: flex-start;
  padding: 0.67rem 0.67rem 0 0.67rem;
  background: #fff;
  cursor: pointer;
  &:hover {
    filter: brightness(0.96);
  }
  .left {
    position: relative;
    box-sizing: border-box;
    margin-right: 0.56rem;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    .image {
      width: 3.78rem;
      height: 3.78rem;
      border-radius: 0.44rem;
    }
    .state {
      font-weight: 400;
      font-size: 13px;
      color: #00b841;
      margin-top: 0.25rem;
    }
  }
  .right {
    position: relative;
    box-sizing: border-box;
    width: 17rem;
    .title {
      font-weight: 550;
      font-size: 13px;
      color: #333333;
      line-height: 1.04rem;
      margin-bottom: 0.25rem;
    }
    .text {
      font-weight: 400;
      font-size: 12px;
      color: #777777;
      line-height: 0.78rem;
      margin-bottom: 0.25rem;
      .city {
        margin-right: 5px;
      }
    }
    .tag {
      margin-bottom: 0.67rem;
      .item {
        font-weight: 400;
        font-size: 12px;
        color: #fe552e;
        line-height: 0.72rem;
        text-align: center;
        margin-right: 0.25rem;
        box-sizing: border-box;
        padding: 0.12rem 0.22rem;
        border-radius: 0.11rem;
        border: 0.03rem solid #fe552e;
      }
    }
    .desc {
      font-weight: 400;
      font-size: 0.67rem;
      color: #777777;
      line-height: 1.22rem;
      text-align: left;
    }
  }
  .action {
    position: absolute;
    top: 0.67rem;
    right: 0.25rem;
    height: 1.39rem;
    line-height: 1.39rem;
    background: #ff590e;
    border-radius: 2.83rem;
    box-sizing: border-box;
    padding: 0 0.5rem;
    font-weight: 500;
    font-size: 12px;
    color: #ffffff;
    &:hover {
      filter: brightness(0.96);
    }
  }
`;
