import React, { useEffect, useState } from 'react';
import { Button } from 'antd';
import { useRouter } from 'next/router';
import { useDispatch } from 'react-redux';
import styled from 'styled-components';
import { InterDataType } from '@/api/interface';
import { SelectCurriculumClassifyType } from '@/api/interface/course';
import { CourseAPI } from '@/api/modules/course';
import { setGlobalData } from '@/store/module/globalData';

// 列表类型
type ListType = Array<
  InterDataType<SelectCurriculumClassifyType>[0] & {
    children: InterDataType<SelectCurriculumClassifyType>;
  }
>;

const TabView04 = () => {
  // 导航钩子
  const router = useRouter();
  // store
  const dispatch = useDispatch();
  // 列表数据
  const [tabList, setTabList] = useState<ListType>([]);
  // 获取执照培训分类
  const getCategoryInfo = async () => {
    const res = await CourseAPI.selectCurriculumClassify();
    if (res && res.code === '200') {
      setTabList(
        res.result
          ?.filter((i) => !i.twoCourseId)
          ?.map((i) => {
            const children = res.result?.filter(
              (k) => k.oneCourseId === i.oneCourseId && k.twoCourseId,
            );
            return {
              ...i,
              children,
            };
          }),
      );
    }
  };
  // 跳转一级分类详情
  const handleMain = (i: ListType[0]) => {
    dispatch(
      setGlobalData({
        loadingSpinnerVisible: true,
      }),
    );
    router.push(`/course/${i?.oneCourseId}`).then();
  };
  // 跳转二级分类详情
  const handleSecond = (i: ListType[0], n: ListType[0]['children'][0]) => {
    dispatch(
      setGlobalData({
        loadingSpinnerVisible: true,
      }),
    );
    router.push(`/course/${i?.oneCourseId}/${n?.twoCourseId}`).then();
  };
  // 组件挂载
  useEffect(() => {
    getCategoryInfo().then();
  }, []);
  return (
    <TabViewWrap className="animate__animated animate__fast animate__fadeIn">
      {tabList.map((i, j) => (
        <div className="tab-item align-start flex" key={j}>
          <div className={'tab-little flex-start'}>
            {!!i.classifyUrl && (
              <img src={i.classifyUrl} alt={i.name} className="title-image" />
            )}
            <Button
              type={'link'}
              className="title-name"
              onClick={() => handleMain(i)}
            >
              {i.name}
            </Button>
          </div>
          <div className="tab-list flex-start">
            {i.children?.map((n, m) => (
              <Button
                type={'link'}
                key={m}
                className="list-item"
                onClick={() => handleSecond(i, n)}
              >
                {n.name}
              </Button>
            ))}
          </div>
        </div>
      ))}
    </TabViewWrap>
  );
};
// 样式
const TabViewWrap = styled.div`
  position: relative;
  width: 100%;
  box-sizing: border-box;
  padding: 0.79rem 1.58rem;
  //background: lightyellow;
  .tab-item {
    position: relative;
    width: 100%;
    box-sizing: border-box;
    margin-bottom: 0.48rem;
    padding-bottom: 0.48rem;
    border-bottom: 0.02rem solid #ededed;
    &:last-child {
      border: none;
    }
  }
  .tab-little {
    position: relative;
    box-sizing: border-box;
    //padding-bottom: 0.68rem;
    //border-bottom: 0.02rem solid #ededed;
    //margin-bottom: 0.5rem;
    .title-image {
      width: 1.68rem;
      height: 1.68rem;
      margin-right: 0.5rem;
    }
    .title-name {
      font-size: 0.78rem;
      font-weight: 550;
      color: #333333;
      padding: 0;
    }
  }
  .tab-list {
    position: relative;
    flex-wrap: wrap;
    max-width: calc(100% - 6rem);
    transform: translateY(0.86px);
    //height: 1.58rem;
    //overflow: hidden;
    //margin-bottom: 1rem;
    //transform: translateX(-10px);
    .list-item {
      color: #666666;
      font-weight: 500;
      padding-right: 0;
    }
  }
  @media (prefers-color-scheme: dark) {
    .tab-little {
      .title-name {
        color: #fff;
      }
    }
    .tab-list {
      .list-item {
        color: #999;
      }
    }
  }
`;
export default TabView04;
