import {
  CourseDetailType,
  QueryCurriculumInfoListType,
  SelectCurriculumClassifyType,
} from '@/api/interface/course';
import request from '@/api/request';

export class CourseAPI {
  // 所有课程分类列表
  static selectCurriculumClassify: SelectCurriculumClassifyType = (params) =>
    request.get('/release/curriculum/selectCurriculumClassify', { params });

  // 课程列表
  static getCourseVideoList: QueryCurriculumInfoListType = (params) =>
    request.post('/release/curriculum/queryCurriculumInfoList', params);

  // 课程详情
  static getCourseDetail: CourseDetailType = (params, config) =>
    request.get('/release/curriculum/curriculumDetails', { params, ...config });
}
