import React, { useState } from 'react';
import { Avatar, Button, Space, Tabs } from 'antd';
import type { TabsProps } from 'antd';
import styles from './index.module.scss';
import { useRouter } from "next/router";

const items: TabsProps['items'] = [
  {
    key: '/home',
    label: `  首页  `,
  },
  {
    key: '1',
    label: `作业服务`,
  },
  {
    key: '2',
    label: `设备租赁`,
  },
  {
    key: '3',
    label: `飞手服务`,
  },
  {
    key: '/mall',
    label: `产品商城`,
  },
  {
    key: '/projectInfo',
    label: `项目资讯`,
  },
  {
    key: '6',
    label: `社区论坛`,
  },
];

export default function NavHeader() {
  const router = useRouter();
  const currentPath = router.asPath;
  
  console.log("currentHash", currentPath);
  const onChange = (key: string) => {
    console.log(key);
    router.push(key);
  };

  return (
    <div className={styles.navHeader}>
      <div className={styles.logo}></div>
      <Tabs
        className={styles.tabs}
        defaultActiveKey={currentPath}
        items={items}
        onChange={onChange}
      />
      <Space size={16} className={styles.btns}>
        <Button type='primary' className={styles.btn1}>
          + 发布信息
        </Button>
        <Button className={styles.btn2}>入驻加盟</Button>
      </Space>
      <div className={styles.haedImg}>
        <Avatar size={48} style={{ background: '#fff' }}></Avatar>
      </div>
    </div>
  );
}
