import React from 'react';
import { ConfigProvider, theme, App as AppView } from 'antd';
import zhCN from 'antd/locale/zh_CN';
import type { AppProps } from 'next/app';
import '../styles/animate.css';
import '../styles/globals.css';
import { Provider } from 'react-redux';
import { PersistGate } from 'redux-persist/integration/react';
import { wrapper } from '@/store';
import themeConfig from '../theme/themeConfig';

const App = ({ Component, ...rest }: AppProps) => {
  const { store, props } = wrapper.useWrappedStore(rest);

  return (
    <Provider store={store}>
      {/* eslint-disable-next-line no-underscore-dangle */}
      <PersistGate persistor={(store as any)?.__persistor} loading={null}>
        <ConfigProvider
          locale={zhCN}
          theme={{
            algorithm: theme.compactAlgorithm,
            ...themeConfig,
          }}
        >
          <AppView>
            <Component {...props.pageProps} />
          </AppView>
        </ConfigProvider>
      </PersistGate>
    </Provider>
  );
};

export default App;
