import React from 'react';
import { InterDataType } from '@/api/interface';
import { SelectCurriculumClassifyType } from '@/api/interface/course';
import { CourseAPI } from '@/api/modules/course';
import CourseView from '@/pages/course/_view';
import { wrapper } from '@/store';

// 分类类型
type CategoryListType = Array<
  InterDataType<SelectCurriculumClassifyType>[0] & {
    children: InterDataType<SelectCurriculumClassifyType> | null;
  }
>;
// 每次加载页面都会执行
export const getServerSideProps = wrapper.getServerSideProps(
  (_store) => async () => {
    // 分类数据
    let categoryList: CategoryListType = [];
    // 获取分类数据
    const getCategoryInfo = async () => {
      const res = await CourseAPI.selectCurriculumClassify();
      if (res && res.code === '200') {
        categoryList = res.result
          ?.filter((i) => !i.twoCourseId)
          ?.map((i) => {
            const children = res.result?.filter(
              (k) => k.oneCourseId === i.oneCourseId && k.twoCourseId,
            );
            return {
              ...i,
              children: children?.length ? children : null,
            };
          });
      }
    };
    // 依次获取接口数据
    await (async () => {
      await Promise.all([getCategoryInfo()]);
    })();
    return { props: { categoryList } };
  },
);

const CoursePageView: React.FC<{ categoryList: CategoryListType }> = (
  props,
) => <CourseView {...props} />;

export default CoursePageView;
